/* term_redisplay.c generated by valac 0.52.3, the Vala compiler
 * generated from term_redisplay.vala, do not modify */

/* Redisplay engine

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */
/* Zile font codes */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <estr.h>

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
typedef struct _WindowPrivate WindowPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

extern Window* cur_wp;
extern Buffer* cur_bp;
extern Flags thisflag;
extern gsize col;
gsize col = 0UL;
extern gsize cur_topline;
gsize cur_topline = (gsize) 0;
extern Window* head_wp;

#define FONT_NORMAL 0000
#define FONT_REVERSE 0001
#define FONT_UNDERLINE 0002
gchar* make_char_printable (gchar c,
                            gsize x,
                            gsize cur_tab_width);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gpointer region_ref (gpointer instance);
void region_unref (gpointer instance);
GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_region (GValue* value,
                       gpointer v_object);
void value_take_region (GValue* value,
                        gpointer v_object);
gpointer value_get_region (const GValue* value);
GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
void draw_line (gsize line,
                gsize startcol,
                Window* wp,
                gsize o,
                Region* r,
                gboolean highlight,
                gsize cur_tab_width);
void term_move (gsize y,
                gsize x);
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
gsize buffer_line_len (Buffer* self,
                       gsize o);
gboolean region_contains (Region* self,
                          gsize o);
void term_attrset (gsize attr);
gchar buffer_get_char (Buffer* self,
                       gsize o);
void term_addch (gchar c);
void term_addstr (const gchar* s);
gsize term_width (void);
gboolean calculate_highlight_region (Window* wp,
                                     Region** rp);
gboolean get_variable_bool (const gchar* name);
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
gsize window_o (Window* self);
gsize marker_get_o (Marker* self);
Region* region_new (gsize o1,
                    gsize o2);
Region* region_construct (GType object_type,
                          gsize o1,
                          gsize o2);
gchar* make_mode_line_flags (Window* wp);
gchar* make_screen_pos (Window* wp);
gboolean window_top_visible (Window* self);
gboolean window_bottom_visible (Window* self);
gsize buffer_get_length (Buffer* self);
void draw_status_line (gsize line,
                       Window* wp);
const gchar* buffer_get_eol (Buffer* self);
gsize buffer_offset_to_line (Buffer* self,
                             gsize offset);
gsize buffer_calculate_goalc (Buffer* self,
                              gsize o);
GType flags_get_type (void) G_GNUC_CONST ;
void draw_window (gsize topline,
                  Window* wp);
gsize buffer_start_of_line (Buffer* self,
                            gsize o);
gsize buffer_prev_line (Buffer* self,
                        gsize o);
gsize buffer_tab_width (Buffer* self);
void term_clrtoeol (void);
gsize buffer_next_line (Buffer* self,
                        gsize o);
void term_redisplay (void);
gsize buffer_line_o (Buffer* self);
void term_redraw_cursor (void);
void term_finish (void);
gsize term_height (void);
void term_refresh (void);
void term_close (void);

gchar*
make_char_printable (gchar c,
                     gsize x,
                     gsize cur_tab_width)
{
	gboolean _tmp1_ = FALSE;
	gchar* result = NULL;
#line 26 "src/term_redisplay.vala"
	if (c == '\t') {
#line 334 "term_redisplay.c"
		gchar* _tmp0_;
#line 27 "src/term_redisplay.vala"
		_tmp0_ = g_strdup_printf ("%*s", (gint) (cur_tab_width - (x % cur_tab_width)), "");
#line 27 "src/term_redisplay.vala"
		result = _tmp0_;
#line 27 "src/term_redisplay.vala"
		return result;
#line 342 "term_redisplay.c"
	}
#line 28 "src/term_redisplay.vala"
	if (((gint) c) >= 0) {
#line 28 "src/term_redisplay.vala"
		_tmp1_ = ((gint) c) <= 033;
#line 348 "term_redisplay.c"
	} else {
#line 28 "src/term_redisplay.vala"
		_tmp1_ = FALSE;
#line 352 "term_redisplay.c"
	}
#line 28 "src/term_redisplay.vala"
	if (_tmp1_) {
#line 356 "term_redisplay.c"
		gchar* _tmp2_;
#line 29 "src/term_redisplay.vala"
		_tmp2_ = g_strdup_printf ("^%c", (gint) ('@' + c));
#line 29 "src/term_redisplay.vala"
		result = _tmp2_;
#line 29 "src/term_redisplay.vala"
		return result;
#line 364 "term_redisplay.c"
	} else {
		gchar* _tmp3_;
#line 31 "src/term_redisplay.vala"
		_tmp3_ = g_strdup_printf ("\\%o", (guint) (c & 0xff));
#line 31 "src/term_redisplay.vala"
		result = _tmp3_;
#line 31 "src/term_redisplay.vala"
		return result;
#line 373 "term_redisplay.c"
	}
}

void
draw_line (gsize line,
           gsize startcol,
           Window* wp,
           gsize o,
           Region* r,
           gboolean highlight,
           gsize cur_tab_width)
{
	gsize x = 0UL;
	gsize i = 0UL;
	gsize line_len = 0UL;
	Buffer* _tmp0_;
#line 34 "src/term_redisplay.vala"
	g_return_if_fail (wp != NULL);
#line 36 "src/term_redisplay.vala"
	term_move (line, (gsize) 0);
#line 39 "src/term_redisplay.vala"
	_tmp0_ = wp->bp;
#line 39 "src/term_redisplay.vala"
	line_len = buffer_line_len (_tmp0_, o);
#line 398 "term_redisplay.c"
	{
		gboolean _tmp1_ = FALSE;
#line 40 "src/term_redisplay.vala"
		x = (gsize) 0;
#line 40 "src/term_redisplay.vala"
		i = startcol;
#line 40 "src/term_redisplay.vala"
		_tmp1_ = TRUE;
#line 40 "src/term_redisplay.vala"
		while (TRUE) {
#line 409 "term_redisplay.c"
			gint _tmp3_ = 0;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gchar c = '\0';
			Buffer* _tmp6_;
#line 40 "src/term_redisplay.vala"
			if (!_tmp1_) {
#line 417 "term_redisplay.c"
				gsize _tmp2_;
#line 40 "src/term_redisplay.vala"
				_tmp2_ = i;
#line 40 "src/term_redisplay.vala"
				i = _tmp2_ + 1;
#line 423 "term_redisplay.c"
			}
#line 40 "src/term_redisplay.vala"
			_tmp1_ = FALSE;
#line 41 "src/term_redisplay.vala"
			if (highlight) {
#line 41 "src/term_redisplay.vala"
				_tmp4_ = region_contains (r, o + i);
#line 431 "term_redisplay.c"
			} else {
#line 41 "src/term_redisplay.vala"
				_tmp4_ = FALSE;
#line 435 "term_redisplay.c"
			}
#line 41 "src/term_redisplay.vala"
			if (_tmp4_) {
#line 41 "src/term_redisplay.vala"
				_tmp3_ = FONT_REVERSE;
#line 441 "term_redisplay.c"
			} else {
#line 41 "src/term_redisplay.vala"
				_tmp3_ = FONT_NORMAL;
#line 445 "term_redisplay.c"
			}
#line 41 "src/term_redisplay.vala"
			term_attrset ((gsize) _tmp3_);
#line 42 "src/term_redisplay.vala"
			if (i >= line_len) {
#line 42 "src/term_redisplay.vala"
				_tmp5_ = TRUE;
#line 453 "term_redisplay.c"
			} else {
#line 42 "src/term_redisplay.vala"
				_tmp5_ = x >= wp->ewidth;
#line 457 "term_redisplay.c"
			}
#line 42 "src/term_redisplay.vala"
			if (_tmp5_) {
#line 43 "src/term_redisplay.vala"
				break;
#line 463 "term_redisplay.c"
			}
#line 44 "src/term_redisplay.vala"
			_tmp6_ = wp->bp;
#line 44 "src/term_redisplay.vala"
			c = buffer_get_char (_tmp6_, o + i);
#line 45 "src/term_redisplay.vala"
			if (g_ascii_isprint (c)) {
#line 471 "term_redisplay.c"
				gsize _tmp7_;
#line 46 "src/term_redisplay.vala"
				term_addch (c);
#line 47 "src/term_redisplay.vala"
				_tmp7_ = x;
#line 47 "src/term_redisplay.vala"
				x = _tmp7_ + 1;
#line 479 "term_redisplay.c"
			} else {
				gchar* s = NULL;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
#line 49 "src/term_redisplay.vala"
				_tmp8_ = make_char_printable (c, x, cur_tab_width);
#line 49 "src/term_redisplay.vala"
				s = _tmp8_;
#line 50 "src/term_redisplay.vala"
				_tmp9_ = s;
#line 50 "src/term_redisplay.vala"
				term_addstr (_tmp9_);
#line 51 "src/term_redisplay.vala"
				_tmp10_ = s;
#line 51 "src/term_redisplay.vala"
				_tmp11_ = strlen (_tmp10_);
#line 51 "src/term_redisplay.vala"
				_tmp12_ = _tmp11_;
#line 51 "src/term_redisplay.vala"
				x += (gsize) _tmp12_;
#line 45 "src/term_redisplay.vala"
				_g_free0 (s);
#line 505 "term_redisplay.c"
			}
		}
	}
#line 56 "src/term_redisplay.vala"
	if (x >= term_width ()) {
#line 57 "src/term_redisplay.vala"
		term_move (line, term_width () - 1);
#line 58 "src/term_redisplay.vala"
		term_attrset ((gsize) FONT_NORMAL);
#line 59 "src/term_redisplay.vala"
		term_addstr ("$");
#line 517 "term_redisplay.c"
	} else {
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 61 "src/term_redisplay.vala"
		_tmp13_ = g_strdup_printf ("%*s", (gint) (wp->ewidth - x), "");
#line 61 "src/term_redisplay.vala"
		_tmp14_ = _tmp13_;
#line 61 "src/term_redisplay.vala"
		term_addstr (_tmp14_);
#line 61 "src/term_redisplay.vala"
		_g_free0 (_tmp14_);
#line 529 "term_redisplay.c"
	}
#line 62 "src/term_redisplay.vala"
	term_attrset ((gsize) FONT_NORMAL);
#line 533 "term_redisplay.c"
}

gboolean
calculate_highlight_region (Window* wp,
                            Region** rp)
{
	Region* _vala_rp = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Window* _tmp3_;
	Buffer* _tmp7_;
	Marker* _tmp8_;
	gsize _tmp9_;
	gsize _tmp10_;
	Region* _tmp11_;
	gboolean result = FALSE;
#line 65 "src/term_redisplay.vala"
	g_return_val_if_fail (wp != NULL, FALSE);
#line 66 "src/term_redisplay.vala"
	_vala_rp = NULL;
#line 68 "src/term_redisplay.vala"
	_tmp3_ = cur_wp;
#line 68 "src/term_redisplay.vala"
	if (wp != _tmp3_) {
#line 68 "src/term_redisplay.vala"
		_tmp2_ = !get_variable_bool ("highlight-nonselected-windows");
#line 561 "term_redisplay.c"
	} else {
#line 68 "src/term_redisplay.vala"
		_tmp2_ = FALSE;
#line 565 "term_redisplay.c"
	}
#line 68 "src/term_redisplay.vala"
	if (_tmp2_) {
#line 68 "src/term_redisplay.vala"
		_tmp1_ = TRUE;
#line 571 "term_redisplay.c"
	} else {
		Buffer* _tmp4_;
		Marker* _tmp5_;
#line 69 "src/term_redisplay.vala"
		_tmp4_ = wp->bp;
#line 69 "src/term_redisplay.vala"
		_tmp5_ = _tmp4_->mark;
#line 69 "src/term_redisplay.vala"
		_tmp1_ = _tmp5_ == NULL;
#line 581 "term_redisplay.c"
	}
#line 68 "src/term_redisplay.vala"
	if (_tmp1_) {
#line 68 "src/term_redisplay.vala"
		_tmp0_ = TRUE;
#line 587 "term_redisplay.c"
	} else {
		Buffer* _tmp6_;
#line 70 "src/term_redisplay.vala"
		_tmp6_ = wp->bp;
#line 70 "src/term_redisplay.vala"
		_tmp0_ = !_tmp6_->mark_active;
#line 594 "term_redisplay.c"
	}
#line 68 "src/term_redisplay.vala"
	if (_tmp0_) {
#line 71 "src/term_redisplay.vala"
		result = FALSE;
#line 71 "src/term_redisplay.vala"
		if (rp) {
#line 71 "src/term_redisplay.vala"
			*rp = _vala_rp;
#line 604 "term_redisplay.c"
		}
#line 71 "src/term_redisplay.vala"
		return result;
#line 608 "term_redisplay.c"
	}
#line 73 "src/term_redisplay.vala"
	_tmp7_ = wp->bp;
#line 73 "src/term_redisplay.vala"
	_tmp8_ = _tmp7_->mark;
#line 73 "src/term_redisplay.vala"
	_tmp9_ = marker_get_o (_tmp8_);
#line 73 "src/term_redisplay.vala"
	_tmp10_ = _tmp9_;
#line 73 "src/term_redisplay.vala"
	_tmp11_ = region_new (window_o (wp), _tmp10_);
#line 73 "src/term_redisplay.vala"
	_vala_rp = _tmp11_;
#line 74 "src/term_redisplay.vala"
	result = TRUE;
#line 74 "src/term_redisplay.vala"
	if (rp) {
#line 74 "src/term_redisplay.vala"
		*rp = _vala_rp;
#line 628 "term_redisplay.c"
	}
#line 74 "src/term_redisplay.vala"
	return result;
#line 632 "term_redisplay.c"
}

gchar*
make_mode_line_flags (Window* wp)
{
	gboolean _tmp0_ = FALSE;
	Buffer* _tmp1_;
	gchar* _tmp8_;
	gchar* result = NULL;
#line 77 "src/term_redisplay.vala"
	g_return_val_if_fail (wp != NULL, NULL);
#line 78 "src/term_redisplay.vala"
	_tmp1_ = wp->bp;
#line 78 "src/term_redisplay.vala"
	if (_tmp1_->modified) {
#line 648 "term_redisplay.c"
		Buffer* _tmp2_;
#line 78 "src/term_redisplay.vala"
		_tmp2_ = wp->bp;
#line 78 "src/term_redisplay.vala"
		_tmp0_ = _tmp2_->readonly;
#line 654 "term_redisplay.c"
	} else {
#line 78 "src/term_redisplay.vala"
		_tmp0_ = FALSE;
#line 658 "term_redisplay.c"
	}
#line 78 "src/term_redisplay.vala"
	if (_tmp0_) {
#line 662 "term_redisplay.c"
		gchar* _tmp3_;
#line 79 "src/term_redisplay.vala"
		_tmp3_ = g_strdup ("%*");
#line 79 "src/term_redisplay.vala"
		result = _tmp3_;
#line 79 "src/term_redisplay.vala"
		return result;
#line 670 "term_redisplay.c"
	} else {
		Buffer* _tmp4_;
#line 80 "src/term_redisplay.vala"
		_tmp4_ = wp->bp;
#line 80 "src/term_redisplay.vala"
		if (_tmp4_->modified) {
#line 677 "term_redisplay.c"
			gchar* _tmp5_;
#line 81 "src/term_redisplay.vala"
			_tmp5_ = g_strdup ("**");
#line 81 "src/term_redisplay.vala"
			result = _tmp5_;
#line 81 "src/term_redisplay.vala"
			return result;
#line 685 "term_redisplay.c"
		} else {
			Buffer* _tmp6_;
#line 82 "src/term_redisplay.vala"
			_tmp6_ = wp->bp;
#line 82 "src/term_redisplay.vala"
			if (_tmp6_->readonly) {
#line 692 "term_redisplay.c"
				gchar* _tmp7_;
#line 83 "src/term_redisplay.vala"
				_tmp7_ = g_strdup ("%%");
#line 83 "src/term_redisplay.vala"
				result = _tmp7_;
#line 83 "src/term_redisplay.vala"
				return result;
#line 700 "term_redisplay.c"
			}
		}
	}
#line 84 "src/term_redisplay.vala"
	_tmp8_ = g_strdup ("--");
#line 84 "src/term_redisplay.vala"
	result = _tmp8_;
#line 84 "src/term_redisplay.vala"
	return result;
#line 710 "term_redisplay.c"
}

gchar*
make_screen_pos (Window* wp)
{
	gboolean tv = FALSE;
	gboolean bv = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
#line 87 "src/term_redisplay.vala"
	g_return_val_if_fail (wp != NULL, NULL);
#line 88 "src/term_redisplay.vala"
	tv = window_top_visible (wp);
#line 89 "src/term_redisplay.vala"
	bv = window_bottom_visible (wp);
#line 91 "src/term_redisplay.vala"
	if (tv) {
#line 91 "src/term_redisplay.vala"
		_tmp0_ = bv;
#line 730 "term_redisplay.c"
	} else {
#line 91 "src/term_redisplay.vala"
		_tmp0_ = FALSE;
#line 734 "term_redisplay.c"
	}
#line 91 "src/term_redisplay.vala"
	if (_tmp0_) {
#line 738 "term_redisplay.c"
		gchar* _tmp1_;
#line 92 "src/term_redisplay.vala"
		_tmp1_ = g_strdup ("All");
#line 92 "src/term_redisplay.vala"
		result = _tmp1_;
#line 92 "src/term_redisplay.vala"
		return result;
#line 746 "term_redisplay.c"
	} else {
#line 93 "src/term_redisplay.vala"
		if (tv) {
#line 750 "term_redisplay.c"
			gchar* _tmp2_;
#line 94 "src/term_redisplay.vala"
			_tmp2_ = g_strdup ("Top");
#line 94 "src/term_redisplay.vala"
			result = _tmp2_;
#line 94 "src/term_redisplay.vala"
			return result;
#line 758 "term_redisplay.c"
		} else {
#line 95 "src/term_redisplay.vala"
			if (bv) {
#line 762 "term_redisplay.c"
				gchar* _tmp3_;
#line 96 "src/term_redisplay.vala"
				_tmp3_ = g_strdup ("Bot");
#line 96 "src/term_redisplay.vala"
				result = _tmp3_;
#line 96 "src/term_redisplay.vala"
				return result;
#line 770 "term_redisplay.c"
			} else {
				Buffer* _tmp4_;
				gsize _tmp5_;
				gsize _tmp6_;
				gchar* _tmp7_;
#line 98 "src/term_redisplay.vala"
				_tmp4_ = wp->bp;
#line 98 "src/term_redisplay.vala"
				_tmp5_ = buffer_get_length (_tmp4_);
#line 98 "src/term_redisplay.vala"
				_tmp6_ = _tmp5_;
#line 98 "src/term_redisplay.vala"
				_tmp7_ = g_strdup_printf ("%2d%%", (gint) ((((gfloat) 100.0) * window_o (wp)) / _tmp6_));
#line 98 "src/term_redisplay.vala"
				result = _tmp7_;
#line 98 "src/term_redisplay.vala"
				return result;
#line 788 "term_redisplay.c"
			}
		}
	}
}

void
draw_status_line (gsize line,
                  Window* wp)
{
	gchar* eol_type = NULL;
	Buffer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gsize n = 0UL;
	Buffer* _tmp11_;
	gchar* a = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	Buffer* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	Buffer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	Buffer* _tmp24_;
	Flags _tmp27_;
	Buffer* _tmp30_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
#line 101 "src/term_redisplay.vala"
	g_return_if_fail (wp != NULL);
#line 102 "src/term_redisplay.vala"
	term_attrset ((gsize) FONT_REVERSE);
#line 104 "src/term_redisplay.vala"
	term_move (line, (gsize) 0);
#line 829 "term_redisplay.c"
	{
		gsize i = 0UL;
#line 105 "src/term_redisplay.vala"
		i = (gsize) 0;
#line 834 "term_redisplay.c"
		{
			gboolean _tmp0_ = FALSE;
#line 105 "src/term_redisplay.vala"
			_tmp0_ = TRUE;
#line 105 "src/term_redisplay.vala"
			while (TRUE) {
#line 105 "src/term_redisplay.vala"
				if (!_tmp0_) {
#line 843 "term_redisplay.c"
					gsize _tmp1_;
#line 105 "src/term_redisplay.vala"
					i = i + 1;
#line 105 "src/term_redisplay.vala"
					_tmp1_ = i;
#line 849 "term_redisplay.c"
				}
#line 105 "src/term_redisplay.vala"
				_tmp0_ = FALSE;
#line 105 "src/term_redisplay.vala"
				if (!(i < wp->ewidth)) {
#line 105 "src/term_redisplay.vala"
					break;
#line 857 "term_redisplay.c"
				}
#line 106 "src/term_redisplay.vala"
				term_addstr ("-");
#line 861 "term_redisplay.c"
			}
		}
	}
#line 109 "src/term_redisplay.vala"
	_tmp2_ = cur_bp;
#line 109 "src/term_redisplay.vala"
	_tmp3_ = buffer_get_eol (_tmp2_);
#line 109 "src/term_redisplay.vala"
	_tmp4_ = _tmp3_;
#line 109 "src/term_redisplay.vala"
	if (g_strcmp0 (_tmp4_, IMMUTABLE_ESTR_eol_cr) == 0) {
#line 873 "term_redisplay.c"
		gchar* _tmp5_;
#line 110 "src/term_redisplay.vala"
		_tmp5_ = g_strdup ("(Mac)");
#line 110 "src/term_redisplay.vala"
		_g_free0 (eol_type);
#line 110 "src/term_redisplay.vala"
		eol_type = _tmp5_;
#line 881 "term_redisplay.c"
	} else {
		Buffer* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
#line 111 "src/term_redisplay.vala"
		_tmp6_ = cur_bp;
#line 111 "src/term_redisplay.vala"
		_tmp7_ = buffer_get_eol (_tmp6_);
#line 111 "src/term_redisplay.vala"
		_tmp8_ = _tmp7_;
#line 111 "src/term_redisplay.vala"
		if (g_strcmp0 (_tmp8_, IMMUTABLE_ESTR_eol_crlf) == 0) {
#line 894 "term_redisplay.c"
			gchar* _tmp9_;
#line 112 "src/term_redisplay.vala"
			_tmp9_ = g_strdup ("(DOS)");
#line 112 "src/term_redisplay.vala"
			_g_free0 (eol_type);
#line 112 "src/term_redisplay.vala"
			eol_type = _tmp9_;
#line 902 "term_redisplay.c"
		} else {
			gchar* _tmp10_;
#line 114 "src/term_redisplay.vala"
			_tmp10_ = g_strdup (":");
#line 114 "src/term_redisplay.vala"
			_g_free0 (eol_type);
#line 114 "src/term_redisplay.vala"
			eol_type = _tmp10_;
#line 911 "term_redisplay.c"
		}
	}
#line 116 "src/term_redisplay.vala"
	term_move (line, (gsize) 0);
#line 117 "src/term_redisplay.vala"
	_tmp11_ = wp->bp;
#line 117 "src/term_redisplay.vala"
	n = buffer_offset_to_line (_tmp11_, window_o (wp));
#line 118 "src/term_redisplay.vala"
	_tmp12_ = eol_type;
#line 118 "src/term_redisplay.vala"
	_tmp13_ = make_mode_line_flags (wp);
#line 118 "src/term_redisplay.vala"
	_tmp14_ = _tmp13_;
#line 118 "src/term_redisplay.vala"
	_tmp15_ = wp->bp;
#line 118 "src/term_redisplay.vala"
	_tmp16_ = _tmp15_->name;
#line 118 "src/term_redisplay.vala"
	_tmp17_ = make_screen_pos (wp);
#line 118 "src/term_redisplay.vala"
	_tmp18_ = _tmp17_;
#line 118 "src/term_redisplay.vala"
	_tmp19_ = wp->bp;
#line 118 "src/term_redisplay.vala"
	_tmp20_ = g_strdup_printf ("(%zu,%zu)", n + 1, buffer_calculate_goalc (_tmp19_, window_o (wp)));
#line 118 "src/term_redisplay.vala"
	_tmp21_ = _tmp20_;
#line 118 "src/term_redisplay.vala"
	_tmp22_ = g_strdup_printf ("--%s%2s  %-15s   %s %-9s (Fundamental", _tmp12_, _tmp14_, _tmp16_, _tmp18_, _tmp21_);
#line 118 "src/term_redisplay.vala"
	_tmp23_ = _tmp22_;
#line 118 "src/term_redisplay.vala"
	_g_free0 (_tmp21_);
#line 118 "src/term_redisplay.vala"
	_g_free0 (_tmp18_);
#line 118 "src/term_redisplay.vala"
	_g_free0 (_tmp14_);
#line 118 "src/term_redisplay.vala"
	a = _tmp23_;
#line 125 "src/term_redisplay.vala"
	_tmp24_ = wp->bp;
#line 125 "src/term_redisplay.vala"
	if (_tmp24_->autofill) {
#line 956 "term_redisplay.c"
		const gchar* _tmp25_;
		gchar* _tmp26_;
#line 126 "src/term_redisplay.vala"
		_tmp25_ = a;
#line 126 "src/term_redisplay.vala"
		_tmp26_ = g_strconcat (_tmp25_, " Fill", NULL);
#line 126 "src/term_redisplay.vala"
		_g_free0 (a);
#line 126 "src/term_redisplay.vala"
		a = _tmp26_;
#line 967 "term_redisplay.c"
	}
#line 127 "src/term_redisplay.vala"
	_tmp27_ = thisflag;
#line 127 "src/term_redisplay.vala"
	if ((_tmp27_ & FLAGS_DEFINING_MACRO) == FLAGS_DEFINING_MACRO) {
#line 973 "term_redisplay.c"
		const gchar* _tmp28_;
		gchar* _tmp29_;
#line 128 "src/term_redisplay.vala"
		_tmp28_ = a;
#line 128 "src/term_redisplay.vala"
		_tmp29_ = g_strconcat (_tmp28_, " Def", NULL);
#line 128 "src/term_redisplay.vala"
		_g_free0 (a);
#line 128 "src/term_redisplay.vala"
		a = _tmp29_;
#line 984 "term_redisplay.c"
	}
#line 129 "src/term_redisplay.vala"
	_tmp30_ = wp->bp;
#line 129 "src/term_redisplay.vala"
	if (_tmp30_->isearch) {
#line 990 "term_redisplay.c"
		const gchar* _tmp31_;
		gchar* _tmp32_;
#line 130 "src/term_redisplay.vala"
		_tmp31_ = a;
#line 130 "src/term_redisplay.vala"
		_tmp32_ = g_strconcat (_tmp31_, " Isearch", NULL);
#line 130 "src/term_redisplay.vala"
		_g_free0 (a);
#line 130 "src/term_redisplay.vala"
		a = _tmp32_;
#line 1001 "term_redisplay.c"
	}
#line 132 "src/term_redisplay.vala"
	_tmp33_ = a;
#line 132 "src/term_redisplay.vala"
	_tmp34_ = g_strconcat (_tmp33_, ")", NULL);
#line 132 "src/term_redisplay.vala"
	_g_free0 (a);
#line 132 "src/term_redisplay.vala"
	a = _tmp34_;
#line 133 "src/term_redisplay.vala"
	_tmp35_ = a;
#line 133 "src/term_redisplay.vala"
	term_addstr (_tmp35_);
#line 135 "src/term_redisplay.vala"
	term_attrset ((gsize) FONT_NORMAL);
#line 101 "src/term_redisplay.vala"
	_g_free0 (a);
#line 101 "src/term_redisplay.vala"
	_g_free0 (eol_type);
#line 1021 "term_redisplay.c"
}

static gpointer
_region_ref0 (gpointer self)
{
#line 141 "src/term_redisplay.vala"
	return self ? region_ref (self) : NULL;
#line 1029 "term_redisplay.c"
}

void
draw_window (gsize topline,
             Window* wp)
{
	gsize i = 0UL;
	gsize o = 0UL;
	Region* r = NULL;
	gboolean highlight = FALSE;
	Region* _tmp0_ = NULL;
	gboolean _tmp1_;
	Region* _tmp2_;
	gsize cur_tab_width = 0UL;
	Buffer* _tmp8_;
	Buffer* _tmp13_;
	gsize _tmp14_;
	gsize _tmp15_;
#line 138 "src/term_redisplay.vala"
	g_return_if_fail (wp != NULL);
#line 141 "src/term_redisplay.vala"
	_tmp1_ = calculate_highlight_region (wp, &_tmp0_);
#line 141 "src/term_redisplay.vala"
	_region_unref0 (r);
#line 141 "src/term_redisplay.vala"
	_tmp2_ = _region_ref0 (_tmp0_);
#line 141 "src/term_redisplay.vala"
	r = _tmp2_;
#line 141 "src/term_redisplay.vala"
	highlight = _tmp1_;
#line 1060 "term_redisplay.c"
	{
		Buffer* _tmp3_;
		gboolean _tmp4_ = FALSE;
#line 144 "src/term_redisplay.vala"
		_tmp3_ = wp->bp;
#line 144 "src/term_redisplay.vala"
		o = buffer_start_of_line (_tmp3_, window_o (wp));
#line 144 "src/term_redisplay.vala"
		i = wp->topdelta;
#line 144 "src/term_redisplay.vala"
		_tmp4_ = TRUE;
#line 144 "src/term_redisplay.vala"
		while (TRUE) {
#line 1074 "term_redisplay.c"
			gboolean _tmp7_ = FALSE;
#line 144 "src/term_redisplay.vala"
			if (!_tmp4_) {
#line 1078 "term_redisplay.c"
				Buffer* _tmp5_;
				gsize _tmp6_;
#line 146 "src/term_redisplay.vala"
				_tmp5_ = wp->bp;
#line 146 "src/term_redisplay.vala"
				o = buffer_prev_line (_tmp5_, o);
#line 146 "src/term_redisplay.vala"
				_vala_assert (o != ((gsize) G_MAXSIZE), "(o = wp.bp.prev_line (o)) != size_t.MAX");
#line 146 "src/term_redisplay.vala"
				i = i - 1;
#line 146 "src/term_redisplay.vala"
				_tmp6_ = i;
#line 1091 "term_redisplay.c"
			}
#line 144 "src/term_redisplay.vala"
			_tmp4_ = FALSE;
#line 145 "src/term_redisplay.vala"
			if (i > ((gsize) 0)) {
#line 145 "src/term_redisplay.vala"
				_tmp7_ = o > ((gsize) 0);
#line 1099 "term_redisplay.c"
			} else {
#line 145 "src/term_redisplay.vala"
				_tmp7_ = FALSE;
#line 1103 "term_redisplay.c"
			}
#line 145 "src/term_redisplay.vala"
			if (!_tmp7_) {
#line 145 "src/term_redisplay.vala"
				break;
#line 1109 "term_redisplay.c"
			}
		}
	}
#line 150 "src/term_redisplay.vala"
	_tmp8_ = wp->bp;
#line 150 "src/term_redisplay.vala"
	cur_tab_width = buffer_tab_width (_tmp8_);
#line 1117 "term_redisplay.c"
	{
		gboolean _tmp9_ = FALSE;
#line 151 "src/term_redisplay.vala"
		i = topline;
#line 151 "src/term_redisplay.vala"
		_tmp9_ = TRUE;
#line 151 "src/term_redisplay.vala"
		while (TRUE) {
#line 1126 "term_redisplay.c"
			Region* _tmp11_;
			Buffer* _tmp12_;
#line 151 "src/term_redisplay.vala"
			if (!_tmp9_) {
#line 1131 "term_redisplay.c"
				gsize _tmp10_;
#line 151 "src/term_redisplay.vala"
				i = i + 1;
#line 151 "src/term_redisplay.vala"
				_tmp10_ = i;
#line 1137 "term_redisplay.c"
			}
#line 151 "src/term_redisplay.vala"
			_tmp9_ = FALSE;
#line 151 "src/term_redisplay.vala"
			if (!(i < (wp->eheight + topline))) {
#line 151 "src/term_redisplay.vala"
				break;
#line 1145 "term_redisplay.c"
			}
#line 153 "src/term_redisplay.vala"
			term_move (i, (gsize) 0);
#line 154 "src/term_redisplay.vala"
			term_clrtoeol ();
#line 157 "src/term_redisplay.vala"
			if (o == ((gsize) G_MAXSIZE)) {
#line 158 "src/term_redisplay.vala"
				continue;
#line 1155 "term_redisplay.c"
			}
#line 160 "src/term_redisplay.vala"
			_tmp11_ = r;
#line 160 "src/term_redisplay.vala"
			draw_line (i, wp->start_column, wp, o, _tmp11_, highlight, cur_tab_width);
#line 162 "src/term_redisplay.vala"
			if (wp->start_column > ((gsize) 0)) {
#line 163 "src/term_redisplay.vala"
				term_move (i, (gsize) 0);
#line 164 "src/term_redisplay.vala"
				term_addstr ("$");
#line 1167 "term_redisplay.c"
			}
#line 167 "src/term_redisplay.vala"
			_tmp12_ = wp->bp;
#line 167 "src/term_redisplay.vala"
			o = buffer_next_line (_tmp12_, o);
#line 1173 "term_redisplay.c"
		}
	}
#line 170 "src/term_redisplay.vala"
	_tmp13_ = wp->bp;
#line 170 "src/term_redisplay.vala"
	_tmp14_ = buffer_get_length (_tmp13_);
#line 170 "src/term_redisplay.vala"
	_tmp15_ = _tmp14_;
#line 170 "src/term_redisplay.vala"
	wp->all_displayed = o >= _tmp15_;
#line 174 "src/term_redisplay.vala"
	if ((wp->fheight - wp->eheight) > ((gsize) 0)) {
#line 175 "src/term_redisplay.vala"
		draw_status_line (topline + wp->eheight, wp);
#line 1188 "term_redisplay.c"
	}
#line 138 "src/term_redisplay.vala"
	_region_unref0 (r);
#line 1192 "term_redisplay.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 183 "src/term_redisplay.vala"
	return self ? buffer_ref (self) : NULL;
#line 1200 "term_redisplay.c"
}

static gpointer
_window_ref0 (gpointer self)
{
#line 215 "src/term_redisplay.vala"
	return self ? window_ref (self) : NULL;
#line 1208 "term_redisplay.c"
}

void
term_redisplay (void)
{
	Buffer* bp = NULL;
	Window* _tmp0_;
	Buffer* _tmp1_;
	Buffer* _tmp2_;
	gsize lastcol = 0UL;
	gsize t = 0UL;
	Buffer* _tmp3_;
	gsize o = 0UL;
	Window* _tmp4_;
	gsize lineo = 0UL;
	Buffer* _tmp5_;
	Window* _tmp6_;
	gsize ew = 0UL;
	Window* _tmp7_;
	gsize topline = 0UL;
#line 183 "src/term_redisplay.vala"
	_tmp0_ = cur_wp;
#line 183 "src/term_redisplay.vala"
	_tmp1_ = _tmp0_->bp;
#line 183 "src/term_redisplay.vala"
	_tmp2_ = _buffer_ref0 (_tmp1_);
#line 183 "src/term_redisplay.vala"
	bp = _tmp2_;
#line 184 "src/term_redisplay.vala"
	lastcol = (gsize) 0;
#line 184 "src/term_redisplay.vala"
	_tmp3_ = bp;
#line 184 "src/term_redisplay.vala"
	t = buffer_tab_width (_tmp3_);
#line 185 "src/term_redisplay.vala"
	_tmp4_ = cur_wp;
#line 185 "src/term_redisplay.vala"
	o = window_o (_tmp4_);
#line 186 "src/term_redisplay.vala"
	_tmp5_ = bp;
#line 186 "src/term_redisplay.vala"
	lineo = o - buffer_line_o (_tmp5_);
#line 188 "src/term_redisplay.vala"
	col = (gsize) 0;
#line 189 "src/term_redisplay.vala"
	o -= lineo;
#line 190 "src/term_redisplay.vala"
	_tmp6_ = cur_wp;
#line 190 "src/term_redisplay.vala"
	_tmp6_->start_column = (gsize) 0;
#line 192 "src/term_redisplay.vala"
	_tmp7_ = cur_wp;
#line 192 "src/term_redisplay.vala"
	ew = _tmp7_->ewidth;
#line 1263 "term_redisplay.c"
	{
		gsize lp = 0UL;
#line 193 "src/term_redisplay.vala"
		lp = lineo;
#line 1268 "term_redisplay.c"
		{
			gboolean _tmp8_ = FALSE;
#line 193 "src/term_redisplay.vala"
			_tmp8_ = TRUE;
#line 193 "src/term_redisplay.vala"
			while (TRUE) {
#line 1275 "term_redisplay.c"
				gboolean _tmp19_ = FALSE;
#line 193 "src/term_redisplay.vala"
				if (!_tmp8_) {
#line 1279 "term_redisplay.c"
					gsize _tmp9_;
#line 193 "src/term_redisplay.vala"
					lp = lp - 1;
#line 193 "src/term_redisplay.vala"
					_tmp9_ = lp;
#line 1285 "term_redisplay.c"
				}
#line 193 "src/term_redisplay.vala"
				_tmp8_ = FALSE;
#line 193 "src/term_redisplay.vala"
				if (!(lp != ((gsize) G_MAXSIZE))) {
#line 193 "src/term_redisplay.vala"
					break;
#line 1293 "term_redisplay.c"
				}
#line 194 "src/term_redisplay.vala"
				col = (gsize) 0;
#line 1297 "term_redisplay.c"
				{
					gsize p = 0UL;
#line 195 "src/term_redisplay.vala"
					p = lp;
#line 1302 "term_redisplay.c"
					{
						gboolean _tmp10_ = FALSE;
#line 195 "src/term_redisplay.vala"
						_tmp10_ = TRUE;
#line 195 "src/term_redisplay.vala"
						while (TRUE) {
#line 1309 "term_redisplay.c"
							gchar c = '\0';
							Buffer* _tmp12_;
#line 195 "src/term_redisplay.vala"
							if (!_tmp10_) {
#line 1314 "term_redisplay.c"
								gsize _tmp11_;
#line 195 "src/term_redisplay.vala"
								p = p + 1;
#line 195 "src/term_redisplay.vala"
								_tmp11_ = p;
#line 1320 "term_redisplay.c"
							}
#line 195 "src/term_redisplay.vala"
							_tmp10_ = FALSE;
#line 195 "src/term_redisplay.vala"
							if (!(p < lineo)) {
#line 195 "src/term_redisplay.vala"
								break;
#line 1328 "term_redisplay.c"
							}
#line 196 "src/term_redisplay.vala"
							_tmp12_ = bp;
#line 196 "src/term_redisplay.vala"
							c = buffer_get_char (_tmp12_, o + p);
#line 197 "src/term_redisplay.vala"
							if (g_ascii_isprint (c)) {
#line 1336 "term_redisplay.c"
								gsize _tmp13_;
#line 198 "src/term_redisplay.vala"
								_tmp13_ = col;
#line 198 "src/term_redisplay.vala"
								col = _tmp13_ + 1;
#line 1342 "term_redisplay.c"
							} else {
								Buffer* _tmp14_;
								gchar* _tmp15_;
								gchar* _tmp16_;
								gint _tmp17_;
								gint _tmp18_;
#line 200 "src/term_redisplay.vala"
								_tmp14_ = bp;
#line 200 "src/term_redisplay.vala"
								_tmp15_ = make_char_printable (buffer_get_char (_tmp14_, o + p), col, t);
#line 200 "src/term_redisplay.vala"
								_tmp16_ = _tmp15_;
#line 200 "src/term_redisplay.vala"
								_tmp17_ = strlen (_tmp16_);
#line 200 "src/term_redisplay.vala"
								_tmp18_ = _tmp17_;
#line 200 "src/term_redisplay.vala"
								col = col + _tmp18_;
#line 200 "src/term_redisplay.vala"
								_g_free0 (_tmp16_);
#line 1363 "term_redisplay.c"
							}
						}
					}
				}
#line 203 "src/term_redisplay.vala"
				if (col >= (ew - 1)) {
#line 203 "src/term_redisplay.vala"
					_tmp19_ = TRUE;
#line 1372 "term_redisplay.c"
				} else {
#line 203 "src/term_redisplay.vala"
					_tmp19_ = ((lp / (ew / 3)) + 2) < (lineo / (ew / 3));
#line 1376 "term_redisplay.c"
				}
#line 203 "src/term_redisplay.vala"
				if (_tmp19_) {
#line 1380 "term_redisplay.c"
					Window* _tmp20_;
#line 204 "src/term_redisplay.vala"
					_tmp20_ = cur_wp;
#line 204 "src/term_redisplay.vala"
					_tmp20_->start_column = lp + 1;
#line 205 "src/term_redisplay.vala"
					col = lastcol;
#line 206 "src/term_redisplay.vala"
					break;
#line 1390 "term_redisplay.c"
				}
#line 209 "src/term_redisplay.vala"
				lastcol = col;
#line 1394 "term_redisplay.c"
			}
		}
	}
#line 213 "src/term_redisplay.vala"
	cur_topline = (gsize) 0;
#line 214 "src/term_redisplay.vala"
	topline = (gsize) 0;
#line 1402 "term_redisplay.c"
	{
		Window* wp = NULL;
		Window* _tmp21_;
		Window* _tmp22_;
#line 215 "src/term_redisplay.vala"
		_tmp21_ = head_wp;
#line 215 "src/term_redisplay.vala"
		_tmp22_ = _window_ref0 (_tmp21_);
#line 215 "src/term_redisplay.vala"
		wp = _tmp22_;
#line 1413 "term_redisplay.c"
		{
			gboolean _tmp23_ = FALSE;
#line 215 "src/term_redisplay.vala"
			_tmp23_ = TRUE;
#line 215 "src/term_redisplay.vala"
			while (TRUE) {
#line 1420 "term_redisplay.c"
				Window* _tmp27_;
				Window* _tmp28_;
				Window* _tmp29_;
				Window* _tmp30_;
				Window* _tmp31_;
#line 215 "src/term_redisplay.vala"
				if (!_tmp23_) {
#line 1428 "term_redisplay.c"
					Window* _tmp24_;
					Window* _tmp25_;
					Window* _tmp26_;
#line 215 "src/term_redisplay.vala"
					_tmp24_ = wp;
#line 215 "src/term_redisplay.vala"
					_tmp25_ = _tmp24_->next;
#line 215 "src/term_redisplay.vala"
					_tmp26_ = _window_ref0 (_tmp25_);
#line 215 "src/term_redisplay.vala"
					_window_unref0 (wp);
#line 215 "src/term_redisplay.vala"
					wp = _tmp26_;
#line 1442 "term_redisplay.c"
				}
#line 215 "src/term_redisplay.vala"
				_tmp23_ = FALSE;
#line 215 "src/term_redisplay.vala"
				_tmp27_ = wp;
#line 215 "src/term_redisplay.vala"
				if (!(_tmp27_ != NULL)) {
#line 215 "src/term_redisplay.vala"
					break;
#line 1452 "term_redisplay.c"
				}
#line 216 "src/term_redisplay.vala"
				_tmp28_ = wp;
#line 216 "src/term_redisplay.vala"
				_tmp29_ = cur_wp;
#line 216 "src/term_redisplay.vala"
				if (_tmp28_ == _tmp29_) {
#line 217 "src/term_redisplay.vala"
					cur_topline = topline;
#line 1462 "term_redisplay.c"
				}
#line 219 "src/term_redisplay.vala"
				_tmp30_ = wp;
#line 219 "src/term_redisplay.vala"
				draw_window (topline, _tmp30_);
#line 221 "src/term_redisplay.vala"
				_tmp31_ = wp;
#line 221 "src/term_redisplay.vala"
				topline += _tmp31_->fheight;
#line 1472 "term_redisplay.c"
			}
		}
#line 215 "src/term_redisplay.vala"
		_window_unref0 (wp);
#line 1477 "term_redisplay.c"
	}
#line 224 "src/term_redisplay.vala"
	term_redraw_cursor ();
#line 181 "src/term_redisplay.vala"
	_buffer_unref0 (bp);
#line 1483 "term_redisplay.c"
}

void
term_redraw_cursor (void)
{
	Window* _tmp0_;
#line 228 "src/term_redisplay.vala"
	_tmp0_ = cur_wp;
#line 228 "src/term_redisplay.vala"
	term_move (cur_topline + _tmp0_->topdelta, col);
#line 1494 "term_redisplay.c"
}

void
term_finish (void)
{
#line 235 "src/term_redisplay.vala"
	term_move (term_height () - 1, (gsize) 0);
#line 236 "src/term_redisplay.vala"
	term_clrtoeol ();
#line 237 "src/term_redisplay.vala"
	term_attrset ((gsize) FONT_NORMAL);
#line 238 "src/term_redisplay.vala"
	term_refresh ();
#line 239 "src/term_redisplay.vala"
	term_close ();
#line 1510 "term_redisplay.c"
}

