/******************************************************************************
 JXGetNewDirDialog.cc

	BASE CLASS = JXDialogDirector

	Copyright  1996 by Glenn W. Bach. All rights reserved.

 ******************************************************************************/

#include <JXGetNewDirDialog.h>
#include <JXWindow.h>
#include <JXStaticText.h>
#include <JXTextButton.h>
#include <JXInputField.h>
#include <jXGlobals.h>
#include <JString.h>
#include <jDirUtil.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXGetNewDirDialog::JXGetNewDirDialog
	(
	JXDirector*			supervisor,
	const JCharacter*	windowTitle,
	const JCharacter*	message,
	const JCharacter*	initialName,
	const JCharacter*	basePath
	)
	:
	JXDialogDirector(supervisor, kFalse)
{
	assert( JDirectoryExists(basePath) );

	itsBasePath = new JString(basePath);
	assert( itsBasePath != NULL );

	BuildWindow(windowTitle, message, initialName);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXGetNewDirDialog::~JXGetNewDirDialog()
{
	delete itsBasePath;
}

/******************************************************************************
 GetNewDirName

 ******************************************************************************/

JString
JXGetNewDirDialog::GetNewDirName()
	const
{
	JString dirName = itsPathName->GetText();
	if (dirName.GetFirstCharacter() != '/')
		{
		dirName = JCombinePathAndName(*itsBasePath, dirName);
		}
	return dirName;
}

/******************************************************************************
 BuildWindow (private)

 ******************************************************************************/

void
JXGetNewDirDialog::BuildWindow
	(
	const JCharacter* windowTitle,
	const JCharacter* message,
	const JCharacter* initialName
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 270,110, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 149,79, 62,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 50,80, 60,20);
    assert( cancelButton != NULL );
    cancelButton->SetShortcuts("^[");

    itsPathName =
        new JXInputField(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,40, 230,20);
    assert( itsPathName != NULL );

    JXStaticText* messageObj =
        new JXStaticText("", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,20, 230,20);
    assert( messageObj != NULL );

// end JXLayout

	window->SetTitle(windowTitle);
	SetButtons(okButton, cancelButton);

	messageObj->SetText(message);

	itsPathName->SetText(initialName);
	itsPathName->SetIsRequired();
}

/******************************************************************************
 OKToDeactivate (virtual protected)

 ******************************************************************************/

JBoolean
JXGetNewDirDialog::OKToDeactivate()
{
	if (!JXDialogDirector::OKToDeactivate())
		{
		return kFalse;
		}
	else if (Cancelled())
		{
		return kTrue;
		}

	const JString pathName = GetNewDirName();
	if (JDirectoryExists(pathName))
		{
		(JGetUserNotification())->ReportError("This directory already exists.");
		return kFalse;
		}
	else if (JNameUsed(pathName))
		{
		(JGetUserNotification())->ReportError("This name is in use.");
		return kFalse;
		}
	else
		{
		return kTrue;
		}
}
