/******************************************************************************
 JXKeyModifiers.h

	Interface for JXKeyModifiers class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXKeyModifiers
#define _H_JXKeyModifiers

#include <X11/Xlib.h>
#include <jTypes.h>

const JSize kXModifierCount = 8;

enum JXModifierKey
{
	kJXShiftKeyIndex = 1,
	kJXShiftLockKeyIndex,
	kJXControlKeyIndex,
	kJXMod1KeyIndex,
	kJXMod2KeyIndex,
	kJXMod3KeyIndex,
	kJXMod4KeyIndex,
	kJXMod5KeyIndex,

	kJXMetaKeyIndex = kJXMod1KeyIndex
};

class JXKeyModifiers
{
public:

	JXKeyModifiers();
	JXKeyModifiers(const unsigned int state);

	JBoolean		GetState(const JIndex i) const;
	void			SetState(const JIndex i, const JBoolean pushed);
	JBoolean		AllOff() const;

	unsigned int	GetState() const;
	void			SetState(const unsigned int state);

	void			Clear();

	JBoolean
	key(const JIndex i)
		const
	{
		return GetState(i);
	};

	JBoolean
	shift()
		const
	{
		return itsState[0];
	};

	JBoolean
	shiftLock()
		const
	{
		return itsState[1];
	};

	JBoolean
	control()
		const
	{
		return itsState[2];
	};

	JBoolean
	meta()
		const
	{
		return itsState[3];
	};

	void
	ToggleState(const JIndex i)
	{
		SetState(i, JNegate(GetState(i)));
	};

	static JBoolean
	AllOff(const unsigned int state)
	{
		return JConvertToBoolean( (state & 0x00FF) == 0 );
	};

	static JBoolean		GetState(const unsigned int state, const JIndex i);
	static unsigned int	SetState(const unsigned int state,
								 const JIndex i, const JBoolean pushed);

	static unsigned int
	ToggleState(const unsigned int state, const JIndex i)
	{
		return SetState(state, i, JNegate(GetState(state, i)));
	};

private:

	JBoolean itsState[ kXModifierCount ];
};

#endif
