/******************************************************************************
 JXUNIXDirUpdateTask.cc

	Idle task to update a directory listing.

	BASE CLASS = JXIdleTask

	Copyright  1996 by Glenn W. Bach. All rights reserved.

 ******************************************************************************/

#include <JXUNIXDirUpdateTask.h>
#include <JXUNIXDirTable.h>

const Time kDirUpdateDelay = 1000;	// milliseconds

/******************************************************************************
 Constructor

 ******************************************************************************/

JXUNIXDirUpdateTask::JXUNIXDirUpdateTask
	(
	JXUNIXDirTable* dirTable
	)
	:
	JXIdleTask(kDirUpdateDelay)
{
	itsDirTable = dirTable;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXUNIXDirUpdateTask::~JXUNIXDirUpdateTask()
{
}

/******************************************************************************
 Perform

 ******************************************************************************/

void
JXUNIXDirUpdateTask::Perform
	(
	const Time	delta,
	Time*		maxSleepTime
	)
{
	if (TimeToPerform(delta, maxSleepTime))
		{		
		itsDirTable->UpdateDisplay();
		}
}
