/******************************************************************************
 TestApp.h

	Interface for the TestApp class

	Written by John Lindal.

 ******************************************************************************/

#ifndef _H_TestApp
#define _H_TestApp

#include <JXApplication.h>

class TestDirector;

class TestApp : public JXApplication
{
public:

	static const JCharacter* kAppSignature;

public:

	TestApp(int* argc, char* argv[], const JBoolean wantMDI);

	virtual ~TestApp();

	void	DisplayAbout(JXDisplay* display);

	JBoolean	GetMainDirector(TestDirector** dir) const;
	void		SetMainDirector(TestDirector* dir);

protected:

	virtual void	CleanUpBeforeSuddenDeath(const JXDocumentManager::SafetySaveReason reason);

	virtual void	ReceiveWithFeedback(JBroadcaster* sender, Message* message);

private:

	TestDirector*	itsMainDirector;	// deleted by JXDirector

private:

	// not allowed

	TestApp(const TestApp& source);
	const TestApp& operator=(const TestApp& source);
};


/******************************************************************************
 GetMainDirector

 ******************************************************************************/

inline JBoolean
TestApp::GetMainDirector
	(
	TestDirector** dir
	)
	const
{
	*dir = itsMainDirector;
	return JConvertToBoolean( *dir != NULL );
}

/******************************************************************************
 SetMainDirector

 ******************************************************************************/

inline void
TestApp::SetMainDirector
	(
	TestDirector* dir
	)
{
	itsMainDirector = dir;
}

#endif
