#include <Xclasses/Xclasses.h>
#include <X11/xpm.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define MAXBREITE 		300
#define STARTBREITE		120
#define FILENAMESIZE 	100
#define VORGABEN		10

XCprogram	myprg("imggen",
					XCP_Version,"0.8",
					XCP_Copyright,"(c) by Jrgen Schmitz 1996/1997",
					XCP_Author,"Jrgen Schmitz",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
					XCP_XC_logo,
					XCP_Done);

char *vorgaben[VORGABEN]={"Mailbox FSAI","Fachschaft AI",
						  "Rechenzentrum","Fachbereich AI",
						  "PGP","Schwarzes Brett",
						  "Bcherbrse","interessante Links",
						  "Links in alle Welt","FernFH"
						 };

appwindow mywin;
graphic gfx;
input txt,filename;
button ende,start,savexpm,savegif,filedial;
group maingp;
bordergroup buts,outp;
slider size;
menu mymenu;
fontgroup fnt;
mxknob ismode;
char *modes[]={"Hauptseite","Im Balken",NULL};

int picheight;
file_dialog fldg;

int hgcol,hgcol2;
int col_schatten,col_text,col_balken,col_balkensch,col_ecke1,col_ecke2,col_dunkeltxt,col_helltxt;
int breite=STARTBREITE;

void paint(void)
{
	char austext[30];
	int x,y;
	txt.Input(austext);
//	gfx.Font("-*-helvetica-*-r-*-*-14-*-*-*-*-*-*-*");
	gfx.Font(fnt.GetFont());
	x=(breite-gfx.StringLength(austext))/2;
	y=gfx.FontAscent();
	if (ismode.Selected()==0)
	{
		gfx.Foreground(hgcol);
		gfx.Clear();
		picheight=gfx.FontHeight()+8;
		gfx.Foreground(col_schatten);
		gfx.DrawString(2+x,y+4,austext);
		gfx.Foreground(col_balken);
		gfx.FillRectangle(0,y,breite,4);
		gfx.Foreground(col_balkensch);
		gfx.Line(1,y+4,breite-1,y+4);
		gfx.Line(breite-1,y+1,breite-1,y+4);
		gfx.Foreground(col_text);
	}
	else
	{
		gfx.Foreground(hgcol2);
		gfx.Clear();
		picheight=gfx.FontHeight();
		gfx.Foreground(col_ecke1);
		gfx.Line(0,0,2,0);
		gfx.Line(0,0,0,2);
		gfx.Line(breite-1,picheight,breite-1-2,picheight);
		gfx.Line(breite-1,picheight,breite-1,picheight-2);
		gfx.Foreground(col_ecke2);
		gfx.Line(2,0,0,2);
		gfx.Line(breite-1-2,picheight,breite-1,picheight-2);
		y-=1;
		picheight=gfx.FontHeight()+1;
		gfx.Foreground(col_helltxt);
		gfx.DrawString(x+1,y+1+2,austext);
		gfx.Foreground(col_dunkeltxt);
	}
	gfx.DrawString(x,y+2,austext);
	gfx.Draw();
}

int main(int argc, char *argv[])
{
	mywin.InitSize(10,10,40);
	if (!mywin.Init(argc,argv))
	{
		printf("Error:\nCan't open display\n");
		exit(1);
	}

	mywin.Title("Icon-Generator IMGGEN");
	mywin.IconTitle("IMGGEN");

	maingp.Horiz();
	 buts.Vert();
	 buts.Title("Kontrolle");
	  txt.Text("Text:");
	  txt.MaxChars(25);
	  txt.ID(1);
	 buts.Add(txt);
	  start.Text("Erzeugen");
	  start.ID(1);
	 buts.Add(start);

	  ruler r1;
	  r1.Space(5);
	 buts.Add(r1);
	  filename.Text("Filename:");
	  filename.MaxChars(FILENAMESIZE);
	 buts.Add(filename);
      filedial.Text("Filedialog...");
      filedial.ID(6);
     buts.Add(filedial);
	  savexpm.Text("Sichern als XPM");
	  savexpm.ID(4);
	 buts.Add(savexpm);
	  savegif.Text("Sichern als GIF");
	  savegif.ID(5);
	 buts.Add(savegif);

	  ruler r2;
	  r2.Space(5);
	 buts.Add(r2);
	  ende.Text("Ende");
	  ende.ID(2);
	 buts.Add(ende);
	maingp.Add(buts);
	 outp.Vert();
	 outp.Title("Ausgabe");
	 outp.Center();
	  gfx.Size(MAXBREITE,60);
	 outp.Add(gfx);
	  size.MinValue(10);
	  size.MaxValue(MAXBREITE);
	  size.Value(breite);
	  size.Horiz();
	  size.ID(3);
	 outp.Add(size);
	  ismode.Items(modes);
	  ismode.Selected(0);
	  ismode.Horiz();
	 outp.Add(ismode);

	  ruler r3;
	  r3.Space(5);
	 outp.Add(r3);
	 outp.Add(fnt);
	maingp.Add(outp);

	mymenu.AddMenu("Datei");
	mymenu.Add("Programm beenden","q",1);
	mymenu.AddMenu("Vorgaben");
	for(int i=0;i<VORGABEN;i++)
	{
		char sc[2];
		sc[0]='a'+i;
		sc[1]=0;
		mymenu.Add(vorgaben[i],sc,i+1);
	}
//	mymenu.AddHelpMenu("Xclasses");
//	mymenu.Add("kein Eintrag",1);
//	mymenu.LockItem(3,1);
	mymenu.ID(100);
	mywin.SetGroup(maingp);
	mywin.SetMenu(mymenu);
	mywin.Create();

	hgcol=mywin.AllocColor(0xffff,0xffff,0xffff);
	hgcol2=mywin.AllocColor(0xcccc,0xcccc,0xcccc);
//	col_text=mywin.AllocColor(0xdddd,0x3333,0x3333);
	col_text=mywin.AllocColor(0xdddd,0x2222,0x2222);
	col_balken=mywin.AllocColor(0x4242,0x8787,0xc4c4);
	col_balkensch=mywin.AllocColor(0x0000,0x0000,0x0000);
	col_schatten=mywin.AllocColor(0xcccc,0xcccc,0xcccc);
	col_ecke1=mywin.AllocColor(0xaaaa,0x0000,0x0000);
	col_ecke2=mywin.AllocColor(0xc8c8,0x6969,0x6969);
	col_dunkeltxt=mywin.AllocColor(0x6666,0x6666,0x6666);
	col_helltxt=mywin.AllocColor(0xefef,0xefef,0xefef);

	int pende=0,r;
	while (!pende)
	{
		r=mywin.NextEvent();
		if (r==EV_WINDOWCLOSE)
		{
			if (mywin.CloseMe()) pende=1;
		}
		else if (r==EV_GADGET)
		{
			switch (mywin.ID())
			{
				case 1:
					paint();
					break;
				case 2:
					pende=1;
					break;
				case 3:
					breite=size.Value();
					break;
				case 4:
					{
						char filenme[FILENAMESIZE];
						XpmAttributes xatr;
						filename.Input(filenme);
						xatr.width=breite;
						xatr.height=picheight;
						xatr.valuemask=XpmSize;
						XpmWriteFileFromPixmap(mywin.display(),filenme,gfx.pixmap(),0,&xatr);
					}
					break;
				case 5:
					{
						char filenme[FILENAMESIZE];
						char com[200],*tmp=tmpnam(NULL);
						XpmAttributes xatr;
						filename.Input(filenme);
						xatr.width=breite;
						xatr.height=picheight;
						xatr.valuemask=XpmSize;
						XpmWriteFileFromPixmap(mywin.display(),tmp,gfx.pixmap(),0,&xatr);
						sprintf(com,"xpmtoppm %s|ppmtogif >%s",tmp,filenme);
						system(com);
						remove(tmp);
					}
					break;
				case 6:
					if (fldg.Start(mywin))
					{
						char buf[300];
						char buf2[100];
						fldg.GetDir(buf,sizeof(buf));
						fldg.GetFile(buf2,sizeof(buf2));
						strcat(buf,buf2);
						filename.Default(buf);
					}
					break;
				case 100:
					if (mymenu.Menu()==1 && mymenu.MID()==1) pende=1;
					else if (mymenu.Menu()==2)
					{
						txt.Default(vorgaben[mymenu.MID()-1]);
						paint();
					}
					break;
			}
		}
	}
	mywin.Close();
	return 0;
}
