//
// dlgbox.C  last changed Nov. 11, 1994
// A widget demo.
// This application should run under Motif, Xaw and TIP
//

#include <stream.h>
#include <strstream.h>
#include <stdlib.h>
#include <xmObject.h>

#ifndef ASCII
#define errout cerr
#endif

class DemoWindow : public XmDialogWindow	// XmWindow
{
	bool initWindowSize(int&, int&, int& nw, int& nh)		{ nw = 300; nh = 400; return(TRUE); } 

	void initialize();

	void lbxDemo(void*);
	void msgboxDemo(void*);
	void prompterDemo(void*);
	void selboxDemo(void*);
	void fileboxDemo(void*);
	void userDlgDemo(void*);

	void openNext(void*);
	void close(void*);
	void quit(void*);
public:
	DemoWindow() : XmDialogWindow("Demo Window")	// XmWindow("DemoWindow")
	{ }
#ifdef __GNUG__ // bug in gcc < 2.6
	bool add(XmControl* c, XmObject* o = NULL, cbProc p = NULL, void* d = CB_OBJ_PTR)	{ return(XmDialogWindow::add(c, o, p, d)); }
#endif
	void showOutput(char* txt)	{ edit("display")->setText(txt); }
	void showOutput(ostrstream& out)	{ out.put('\0'); char* s; edit("display")->setText(s = out.str()); delete s; }
};

class DemoDialog : public XmUserDialog
{
	bool initWindowSize(int&, int&, int&, int&);

	void createContents();
	void initContents();

	void myRadioButton(XmRadioButton*);
	void myCheckBox(XmCheckBox*);
	void myEdit(XmEdit*);
	void myListBox(XmListBox*);
	void myComboBox(XmListBox*);
	void myPushButton(XmPushButton*);
	void myQuitButton(XmPushButton*);
public:
	DemoDialog(XmObject* parent = NULL) : XmUserDialog("Demo Dialog", parent)
	{ }
};

DemoWindow* mainWin;

char* items[] = { "One", "Two", "Three", "Four", "Five", "Six", NULL };

// implementation ///////////////////////////////////////////////////////

void DemoWindow::initialize()
{
	XmDropdownMenu* m = createDropdownMenu();

	m->addLabels("&File", "&Test", NULL);

	m->setCurrentLabel("File");
	m->addItems(Entry("&Open", CBK(DemoWindow, openNext)),
		Entry("&Close", CBK(DemoWindow, close)), NULLENTRY);
	m->addSeparator();
	m->addItems(Entry("E&xit", CBK(DemoWindow, quit)), NULLENTRY);

	m->setCurrentLabel("Test");
	m->addItems(Entry("message", "&Message...", CBK(DemoWindow, msgboxDemo)),
		Entry("prompter", "&Prompter...", CBK(DemoWindow, prompterDemo)),
		Entry("selbox", "Se&lection box...", CBK(DemoWindow, selboxDemo)),
		Entry("filesel", "&File selector box...", CBK(DemoWindow, fileboxDemo)),
		NULLENTRY);
	m->addSeparator();
	m->addItems(Entry("usrdlg", "&User Dialog...", CBK(DemoWindow, userDlgDemo)), NULLENTRY);

//	addSubpane(Edit, "display");
	add(new XmEdit("display", 0, 30, 300, 180, XmSmultiLine));
	edit("display")->setText("Hello Tcl!!");
//	addSubpane(ListBox, "selectionArea");
	add(new XmListBox("selectionArea", 0, 210, 300, 180));
	listBox("selectionArea")->addAll(items);
	listBox("selectionArea")->setCallback(this, CBK(DemoWindow, lbxDemo));

	mainWin = this;
}

void DemoWindow::lbxDemo(void* lbx)
{
	ostrstream out;
	XmListBox* l = (XmListBox*)lbx;

	out << "***MAIN WINDOW***\n\nlistBox: " << l->getName() << "\n";
	out << " selected item:  " << l->selectedItem() << "\n"; 
	out << " selected index: " << l->selectedIndex() << "\n";

	out << " all currently selected items: \n";
	char** strings = l->selectedItems();
	int* ndxs = l->selectedIndices();
	for(int i = 0; strings[i]; i++)
		out << strings[i] << " (" << ndxs[i] << ")\n";

	showOutput(out);
}

void DemoWindow::msgboxDemo(void*)
{
	(new XmMsgBox("This is a message.", "Test Message", XmSdlgAppModal | XmSmsgInfo | XmSmsgOk))->showMsg();
	showOutput("viewed the message.");
}

void DemoWindow::prompterDemo(void*)
{
	char* txt = (new XmPrompter("This is a prompter. Enter some text:", "Test Prompter", "nothing"))->prompt();
	showOutput(txt ? txt : " propter canceled.");
}

void DemoWindow::selboxDemo(void*)
{
	int ndx = (new XmListPrompter(items, "This is a list-prompter. Select an item:", "Test List Prompter", "<nothing>"))->promptIndex();
	showOutput(ndx ? items[ndx] : " list prompter canceled.");
}

void DemoWindow::fileboxDemo(void*)
{
	char* txt = (new XmFileSelector("/*"))->promptFile();
	showOutput(txt ? txt : " file selector canceled.");
}

void DemoWindow::userDlgDemo(void*)
{
	(new DemoDialog(this))->open();
}

void DemoWindow::openNext(void*)
{
	(new DemoWindow)->open();
}

void DemoWindow::close(void*)
{
	delete this;
}

void DemoWindow::quit(void*)
{
	App->quit();
}

#include "demodlg.C"

void DemoDialog::initContents()
{
	radioButton("RadioButton1")->setCallback(this, CBK(DemoDialog, myRadioButton));
	radioButton("RadioButton2")->setCallback(this, CBK(DemoDialog, myRadioButton));
	radioButton("RadioButton3")->setCallback(this, CBK(DemoDialog, myRadioButton));
	pushButton("PushButton")->setCallback(this, CBK(DemoDialog, myPushButton));
	checkBox("CheckBox")->setCallback(this, CBK(DemoDialog, myCheckBox));
	edit("Edit1")->setCallback(this, CBK(DemoDialog, myEdit));
	edit("Edit2")->setCallback(this, CBK(DemoDialog, myEdit));
	listBox("ListBox")->addAll(items);
	listBox("ListBox")->setCallback(this, CBK(DemoDialog, myListBox));

	comboBox("ComboBox")->addAll(items);
	comboBox("ComboBox")->setCallback(this, CBK(DemoDialog, myComboBox));

	pushButton("QuitButton")->setCallback(this, CBK(DemoDialog, myQuitButton));
	setDefaultButton("QuitButton");
}

void DemoDialog::myPushButton(XmPushButton* p)
{
	ostrstream out;
	out << "pushButton: " << p->getName() << "\n";
	mainWin->showOutput(out);
}

void DemoDialog::myCheckBox(XmCheckBox* b)
{
	ostrstream out;
	out << "checkBox: " << b->getName() << " state: " << b->getState() << "\n";
	mainWin->showOutput(out);
}

void DemoDialog::myRadioButton(XmRadioButton* r)
{
	ostrstream out;
	out << "radioButton: " << r->getName() << " selected.\n";
	mainWin->showOutput(out);
	char* cursorName = strchr(r->getName(), '1') ? "default" : 
		(strchr(r->getName(), '2') ? "busy" : "cross");
	if(!setCursor(cursorName))
		cerr << "set cursor failed.\n";
}

void DemoDialog::myEdit(XmEdit* e)
{
	ostrstream out;
	out << "edit: " << e->getName() << " new text: " << e->getText() << "\n";
	mainWin->showOutput(out);
}

void DemoDialog::myListBox(XmListBox* l)
{
	ostrstream out;
	out << "listBox: " << l->getName() << " selection: " << l->selectedItem() << " (" << l->selectedIndex() << ")\n";
	out << "  currently selected: \n";
	char** strings = l->selectedItems();
	int* ndxs = l->selectedIndices();
	for(int i = 0; strings[i]; i++)
		out << strings[i] << " (" << ndxs[i] << ")\n";
	out << "\n";
	mainWin->showOutput(out);
}

void DemoDialog::myComboBox(XmListBox* x)
{
	ostrstream out;

	XmComboBox* cbx = comboBox("ComboBox");
	out << "comboBox - current text: " << cbx->getText() << ".\n";
	mainWin->showOutput(out);
}

void DemoDialog::myQuitButton(XmPushButton* p)
{
	delete this;
}


// application init method ///////////////////////////////////////////

void XmApp::initialize()
{
	(new DemoWindow)->open();
};

