/****************************************************************************
** $Id: qfontinf.h,v 2.5 1997/08/06 15:05:37 hanord Exp $
**
** Definition of QFontInfo class
**
** Created : 950131
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QFONTINF_H
#define QFONTINF_H

#include "qfont.h"


class QFontInfo
{
public:
    QFontInfo( const QFont & );
    QFontInfo( const QFontInfo & );
   ~QFontInfo();

    QFontInfo	       &operator=( const QFontInfo & );

    const char	       *family()	const;
    int			pointSize()	const;
    bool		italic()	const;
    int			weight()	const;
    bool		bold()		const;
    bool		underline()	const;
    bool		strikeOut()	const;
    bool		fixedPitch()	const;
    QFont::StyleHint	styleHint()	const;
    QFont::CharSet	charSet()	const;
    bool		rawMode()	const;

    bool		exactMatch()	const;

#if 1	/* OBSOLETE */
    const QFont &font() const;
#endif

private:
    QFontInfo( const QWidget * );
    QFontInfo( const QPainter * );
    static void reset( const QWidget * );
    static void reset( const QPainter * );
    const QFontDef *spec() const;

    enum Type { FontInternal, Widget, Painter };
    union {
	int   flags;
	void *dummy;
    } t;
    union {
	QFontInternal *f;
	QWidget	      *w;
	QPainter      *p;
    } u;

    int	    type()	     const { return t.flags & 0xff; }
    bool    underlineFlag()  const { return (t.flags & 0x100) != 0; }
    bool    strikeOutFlag()  const { return (t.flags & 0x200) != 0; }
    bool    exactMatchFlag() const { return (t.flags & 0x400) != 0; }
    void    setUnderlineFlag()	   { t.flags |= 0x100; }
    void    setStrikeOutFlag()	   { t.flags |= 0x200; }
    void    setExactMatchFlag()	   { t.flags |= 0x400; }

    friend class QWidget;
    friend class QPainter;
};


inline bool QFontInfo::bold() const
{ return weight() > QFont::Normal; }


#endif // QFONTINF_H
