#!/usr/bin/perl
foreach $filename (@ARGV)
{
   # Get type
   $type = scan( $filename );

   # Type 0: Not our source
   if( ! $type )
   {
      print STDERR "$filename isn't a DlgEdit source\n";
      next;
   }

   # Type 1: Already done
   if( $type == -1 )
   {
      print STDERR "$filename is already convertet\n";
      next;
   }

   if( ! open( INPUT, $filename ) )
   {
      print STDERR "Can't open $filename (Errno: $!)\n";
      next;
   }
   if( ! open( OUTPUT, ">$filename.new" ) )
   {
      print STDERR "Can't open $filename.new (Errno: $!)\n";
      next;
   }

   print OUTPUT "DlgEdit:v1.2:$type:\n";

   while( <INPUT> )
   {
      /DlgEdit\s+/ && do { print OUTPUT "Dialog {\n"; next; };
      print OUTPUT $_;
   }
   close( INPUT );
   close( OUTPUT );

   rename( $filename, "$filename.old" );
   rename( "$filename.new", $filename );
}

sub scan
{
   local($filename) = @_;
   local(*INPUT);

   if( ! open( INPUT, $filename ) )
   {
      print STDERR "Can't open $filename (Errno: $!)\n";
      return;
   }

   while( <INPUT> )
   {
      /DlgEdit:.*/    && return -1;
      /DlgEdit *{.*$/ && return "Dialog";
      /Project *{.*$/ && return "Project";
   }

   return 0;
}
