// $Id: DialogList.h,v 1.2 1997/04/17 03:19:44 jharris Exp $

#ifndef DialogList_included
#define DialogList_included

#include <qlistbox.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qpopmenu.h>

class ProjectWnd;
class Project;
class DialogWnd;

class DialogListItem : public QListBoxItem
{
public:
  DialogListItem( DialogWnd * );
  DialogListItem( Project * );

  int height( const QListBox * ) const;
  int width( const QListBox * ) const;

  DialogWnd *GetDialog();
  void       SetDialog( DialogWnd * );

  Project   *GetProject();
  void       SetProject( Project * );

  void ToBeSaved( bool );

  bool IsProject(); 
  bool IsInProject(); 

  void ProjectView( bool );
  // Show or hide all dialogs inside a project

  void DialogClosed( bool = TRUE );
  // A dialog inside a project is closed, change menu

  bool IsDialogClosed();
  // Is this dialog inside a project closed ?

private:
  void Initialize();

  void paint( QPainter * );

  DialogWnd *dialog;
  Project   *project;

  static QPixmap *toBeSaved;
  bool saveItem;

  static QPixmap *projectFolded;
  static QPixmap *projectUnfolded;

  bool dlgAreShown;

  bool dlgClosed;
};


inline int DialogListItem::width( const QListBox *lb ) const
{
  lb = lb;
  return -1;
}

inline DialogWnd *DialogListItem::GetDialog()
{
  return dialog;
}

inline void DialogListItem::SetDialog( DialogWnd *dlg )
{
  dialog = dlg;
}

inline Project *DialogListItem::GetProject()
{
  return project;
}

inline void DialogListItem::SetProject( Project *prj )
{
  project = prj;
}

inline void DialogListItem::ToBeSaved( bool b )
{
  saveItem = b;
}

inline bool DialogListItem::IsProject()
{
  return (project != NULL) && (dialog == NULL);
}

inline bool DialogListItem::IsInProject()
{
  return project != NULL;
}

inline void DialogListItem::ProjectView( bool s )
{
  dlgAreShown = s;
}

inline void DialogListItem::DialogClosed( bool c )
{
  dlgClosed = c;
}

inline bool DialogListItem::IsDialogClosed( )
{
  return dlgClosed;
}

class DialogList : public QListBox
{
  Q_OBJECT

public:
  DialogList( ProjectWnd *, const char * );

  void Append( DialogWnd * );
  // Append a new Dialog

  void Remove( DialogWnd * );
  // Remove a Dialog

  void Append( Project * );
  // Append a new Project

  void Remove( Project * );
  // Remove a Project

  DialogWnd *CurrentItem();
  // returns the current item, if DialogWnd
     
  Project *CurrentProject();
  // returns the Project surrounding the current item, if any

  void AddDialogToProject( Project *prj, DialogWnd *dlg );
  // Append the dialog to the list of dialogs of the project

  void RemoveDialogFromProject( Project *prj, DialogWnd *dlg );
  // Remove the dialog from the list of dialogs of the project
     
  void ShowChange( bool = TRUE );

    int Contains( const QString& dialogName );
    // does the list contain a dialog by this name

  DialogListItem *GetCurrentListItem();
  DialogListItem *GetProjectListItem( Project * );
  DialogListItem *GetDialogListItem( DialogWnd * );
  DialogListItem *GetPrjDlgListItem( Project *, DialogWnd * );
  // Various ways to get a DialogListItem

public slots:
  void Update( DialogWnd * );
  void Update( Project * );
  // Update a row

    void Saved( DialogWnd* );
  void Saved( Project* );
  // a xxx has been saved

  void ToggleView( Project * );
  // Show or hide the dialogs

private: // Methods
  int FindItem( DialogWnd * );
  int FindItem( Project * );

  void mousePressEvent( QMouseEvent * );
  void mouseDoubleClickEvent( QMouseEvent * );

private: // Attributes
  ProjectWnd *theProjectWnd;
  // Pointer to the surrounding ProjectWnd

  bool showChange;
  // true: Show toBeSaved icon
};

inline void DialogList::ShowChange( bool s )
{
  showChange = s;
}

#endif
