/**********************************************************************

	--- Dlgedit generated file ---

	File: GridDialog.cpp
	Last generated: Wed Oct 29 09:39:22 1997

 *********************************************************************/

/*
 * reworked code for the grid dialog,
 * Mirko Sucker, October 29, 
 * 1997
 * implementation
 */


#include "GridDialog.h"
#include <qstring.h>
 #include <qtooltip.h>


#define Inherited GridDialogData

GridDialog::GridDialog
(
 QWidget* parent,
 const char* name,
 int currentGrid
 )
  :
  Inherited( parent, name),
  grid(currentGrid)
{
  // entries in the combobox - add anything you like
  // maybe 50 and 100 are much to huge - who knows?
  static const int entries[] 
    = { 5, 10, 20, 50, 100 };
  unsigned int temp;
  // some dialog settings
  QString aString;
  setCaption( "Grid" );
  // wonder why dialogs are not fixed by default
  setFixedSize(280, 110); 
  // add the entries to the combobox
  for(temp=0; temp<(sizeof(entries)/sizeof(int)); temp++)
    {
      aString.setNum(entries[temp]);
      gridCombo->insertItem(aString);
    }
  if(grid>1) // grid previously enabled?
    {
      enableBox->setChecked(true);
      gridCombo->setEnabled(true);
      // grid should only have values that are elements of gridCombo!
      // (that means do only add values in the "entries" array, 
      // see before)
      // here we determine the index of the current grid in the combobox
      for(temp=0; temp<(sizeof(entries)/sizeof(int)); temp++)
	{
	  if(entries[temp]==grid)
	    {
	      gridCombo->setCurrentItem(temp);
	      break;
	    }
	}
    } else {
      enableBox->setChecked(false);
      gridCombo->setEnabled(false);
    }
  // connections
  connect(enableBox, SIGNAL(toggled(bool)), 
	  gridCombo, SLOT(setEnabled(bool)));
  connect(okButton, SIGNAL(clicked()), SLOT(OKFunc()));
  // add some tooltips
  QToolTip::add(canButton, "abandon changes");
  QToolTip::add(okButton, "accept changes");
  QToolTip::add(enableBox, "enable or disable grid");
  QToolTip::add(gridCombo, "select grid resolution");
}

GridDialog::~GridDialog()
{
  // destructor remains empty
}

// ####################################################
// no changes made by me below thie line --Mirko.
void GridDialog::OKFunc()
{
  if( enableBox->isChecked() )
    {
      QString aString( gridCombo->currentText() );
      grid = aString.toInt();
    }	else
      {
	grid = 1;
      }

  accept();
}

int GridDialog::GetNewGrid()
{
  return grid;
}
