#ifndef Toolbar_included
#define Toolbar_included

#include <qframe.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qpushbt.h>
#include <qsize.h>
#include <qtooltip.h>
#include <qbttngrp.h>


class Toolbar : public QButtonGroup
{
  Q_OBJECT

public:
    
  Toolbar
  ( 
   QWidget*	parent = NULL,
   const char*	name = NULL 
   );
    

  virtual ~Toolbar();

  uint Insert
  (
   const QPixmap&	pixmap,
   const QObject*	receiver,
   const char*	slot,
   const char*	toolTip = NULL,
   const char*	longToolTip = NULL,
   const char* name = NULL,
   const bool = FALSE
   );

  uint Insert
  (
   const int id,
   const QPixmap&	pixmap,
   const QObject*	receiver,
   const char*	slot,
   const char*	toolTip = NULL,
   const char*	longToolTip = NULL,
   const char* name = NULL,
   const bool = FALSE
   );
  // insert the pixmap into a button on the toolbar and connect to the
  // slot for when the button is pushed.  return the index number of the 
  // button.  the long tool tip will be used in the tool tip group
  // If a name is supplied, the new button will be named 

  void InsertSeparator
  (
   int	width = 5
   );

  void ToggleItem
  (
   uint	item
   );
  // Try to toggle the given item

  void EnableItem
  (
   uint	item,
   bool	enable
   );
  // enable or disable one of the buttons on the toolbar

  const QToolTipGroup& GetToolTipGroup( void ) const;
  // get the tool tip group associated with this toolbar

private:

  QSize	itsSize;
  // rectangle of pixmap buttons

  QList<QPushButton>	itsButtonList;
  // list of pushbuttons on the toolbar

  QToolTipGroup	itsToolTipGroup;
  // tool tip group for displaying long messages

};


inline void Toolbar::InsertSeparator
(
    int	width
)
{
    itsSize.rwidth() += width;
}


inline const QToolTipGroup& Toolbar::GetToolTipGroup( void ) const
{
    return itsToolTipGroup;
}


#endif // Toolbar_included


