#ifndef BoxSpacing_included
#define BoxSpacing_included

#include "layout/LayoutItem.h"

#include "widget/Frame.h"

class BoxSpacing : public LayoutItem
{
public: // Methods

    BoxSpacing
    (
	QWidget*	parent,
	WidgetLayout*	widgetLayout,
	int		spacing = 7
    );
    
    virtual ~BoxSpacing();
    
    virtual void AddToLayout
    (
	QBoxLayout*	layout
    );
    // Add the item to the layout

    virtual LayoutItem* FindLayoutItem
    (
	QWidget*	widget
    ) const;
    // Given the widget representing a layout item, return the item or NULL if
    // not found

    virtual void LowerWidget( void );
    // Lower all the widgets representing layout items

    virtual void SaveContents( QTextStream&	stream,
			       QString		id ) const;
    // Save the item's contents to the stream with the given id

    virtual bool RestoreKeyValue( const QString&	key,
				  const QString&	value );
    // Restore a single key/value pair

    virtual void GenerateSource( QTextStream&	stream,
				 const QString&	layoutVarName,
				 const QString&	layoutId ) const;
    // Generate the source for the layout given by layoutVarName.  If the 
    // layoutVarName is empty, the layout is a top level layout

    virtual QString GetItemName( void ) const;
    // Return a text string for the name of this item

    static QString ItemName( void );
    // Static method to return the name of this item

    virtual QRect GetGlobalGeometry( void ) const;
    // Get the global geometry for this layout item

    virtual QWidget* GetPropertyPage
    (
	QWidget*	parent
    );
    // Return a new property page to be used for this item

    int GetSpacing( void ) const;
    
    void SetSpacing
    (
	int	spacing
    );
    // Get/Set methods on the spacing

private: // Methods

    BoxSpacing();
    BoxSpacing( const BoxSpacing& );
    BoxSpacing& operator= ( const BoxSpacing& );
    
private: // Attributes

    Frame*	itsFrame;
    // Frame that reperesents the spacing

    int		itsSpacing;
    // Amount of spacing for the item
};


inline QString BoxSpacing::ItemName( void )
{
    return "Box_Spacing";
}


inline int BoxSpacing::GetSpacing( void ) const
{
    return itsSpacing;
}


inline void BoxSpacing::SetSpacing
(
    int	spacing
)
{
    itsSpacing = spacing;
}


#endif // BoxSpacing_included
