#include <qstring.h>

#include "ColorSelectDialog.h"

#define Inherited ColorSelectDialogData

ColorSelectDialog::ColorSelectDialog
(
    const QColor& color,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    setCaption( "Color Selector" );

    itsColorGroup->insert( itsBlack, Black );
    itsColorGroup->insert( itsWhite, White );
    itsColorGroup->insert( itsDarkGray, DarkGray );
    itsColorGroup->insert( itsGray, Gray );
    itsColorGroup->insert( itsLightGray, LightGray );
    itsColorGroup->insert( itsRed, Red );
    itsColorGroup->insert( itsGreen, Green );
    itsColorGroup->insert( itsBlue, Blue );
    itsColorGroup->insert( itsCyan, Cyan );
    itsColorGroup->insert( itsMagenta, Magenta );
    itsColorGroup->insert( itsYellow, Yellow );
    itsColorGroup->insert( itsDarkRed, DarkRed );
    itsColorGroup->insert( itsDarkGreen, DarkGreen );
    itsColorGroup->insert( itsDarkBlue, DarkBlue );
    itsColorGroup->insert( itsDarkCyan, DarkCyan );
    itsColorGroup->insert( itsDarkMagenta, DarkMagenta );
    itsColorGroup->insert( itsDarkYellow, DarkYellow );

    connect( itsColorGroup, SIGNAL(clicked(int)), SLOT(ColorClicked(int)) );

    connect( itsRedSlide, SIGNAL(valueChanged(int)),
	     SLOT(SliderChanged(int)) );
    connect( itsGreenSlide, SIGNAL(valueChanged(int)), 
	     SLOT(SliderChanged(int)) );
    connect( itsBlueSlide, SIGNAL(valueChanged(int)), 
	     SLOT(SliderChanged(int)) );

    connect( itsRedValue, SIGNAL(textChanged(const char*)),
	     SLOT(TextChanged(const char*)) );
    connect( itsGreenValue, SIGNAL(textChanged(const char*)),
	     SLOT(TextChanged(const char*)) );
    connect( itsBlueValue, SIGNAL(textChanged(const char*)),
	     SLOT(TextChanged(const char*)) );

    connect( itsOkButton, SIGNAL(clicked()), SLOT(accept()) );
    connect( itsCancelButton, SIGNAL(clicked()), SLOT(reject()) );    

    ChangeColor( itsBlack, black );
    ChangeColor( itsWhite, white );
    ChangeColor( itsDarkGray, darkGray );
    ChangeColor( itsGray, gray );
    ChangeColor( itsLightGray, lightGray );
    ChangeColor( itsRed, red );
    ChangeColor( itsGreen, green );
    ChangeColor( itsBlue, blue );
    ChangeColor( itsCyan, cyan );
    ChangeColor( itsMagenta, magenta );
    ChangeColor( itsYellow, yellow );
    ChangeColor( itsDarkRed, darkRed );
    ChangeColor( itsDarkGreen, darkGreen );
    ChangeColor( itsDarkBlue, darkBlue );
    ChangeColor( itsDarkCyan, darkCyan );
    ChangeColor( itsDarkMagenta, darkMagenta );
    ChangeColor( itsDarkYellow, darkYellow );
    ChangeColor( itsSelected, color );

    UpdateSliders( color );
    UpdateTexts( color );
}


ColorSelectDialog::~ColorSelectDialog()
{
}


void ColorSelectDialog::UpdateSliders
(
    const QColor&	color
)
{
    itsRedSlide->setValue( color.red() );
    itsGreenSlide->setValue( color.green() );
    itsBlueSlide->setValue( color.blue() );
}


void ColorSelectDialog::UpdateTexts
(
    const QColor&	color
)
{
    QString str;
    
    itsRedValue->setText( str.setNum( color.red() ) );
    itsGreenValue->setText( str.setNum( color.green() ) );
    itsBlueValue->setText( str.setNum( color.blue() ) );
}


void ColorSelectDialog::SliderChanged
( 
    int 
)
{
    QColor color( itsRedSlide->value(), itsGreenSlide->value(),
		  itsBlueSlide->value() );
    
    UpdateTexts( color );
    ChangeColor( itsSelected, color );
}


void ColorSelectDialog::TextChanged
( 
    const char* 
)
{
    QString str = itsRedValue->text();
    int red = str.toInt();
    if( !str.isEmpty() && (red < 0 || red > 255) )
    {
	str = str.left(str.length() - 1);
	itsRedValue->setText( str );
	itsRedValue->selectAll();
	red = str.toInt();
    }

    str = itsGreenValue->text();
    int green = str.toInt();
    if( !str.isEmpty() && (green < 0 || green > 255) )
    {
	str = str.left(str.length() - 1);
	itsGreenValue->setText( str );
	itsGreenValue->selectAll();
	green = str.toInt();
    }

    str = itsBlueValue->text();
    int blue = str.toInt();
    if( !str.isEmpty() && (blue < 0 || blue > 255) )
    {
	str = str.left(str.length() - 1);
	itsBlueValue->setText( str );
	itsBlueValue->selectAll();
	blue = str.toInt();
    }

    QColor color( red, green, blue );
    
    UpdateSliders( color );
    ChangeColor( itsSelected, color );
}


void ColorSelectDialog::ColorClicked
( 
    int item 
)
{
    QColor color;

    switch( item )
    {
	case Black:
	{
	    color = black;
	    break;
	}
	case White:
	{
	    color = white;
	    break;
	}
	case DarkGray:
	{
	    color = darkGray;
	    break;
	}
	case Gray:
	{
	    color = gray;
	    break;
	}
	case LightGray:
	{
	    color = lightGray;
	    break;
	}
	case Red:
	{
	    color = red;
	    break;
	}
	case Green:
	{
	    color = green;
	    break;
	}
	case Blue:
	{
	    color = blue;
	    break;
	}
	case Cyan:
	{
	    color = cyan;
	    break;
	}
	case Magenta:
	{
	    color = magenta;
	    break;
	}
	case Yellow:
	{
	    color = yellow;
	    break;
	}
	case DarkRed:
	{
	    color = darkRed;
	    break;
	}
	case DarkGreen:
	{
	    color = darkGreen;
	    break;
	}
	case DarkBlue:
	{
	    color = darkBlue;
	    break;
	}
	case DarkCyan:
	{
	    color = darkCyan;
	    break;
	}
	case DarkMagenta:
	{
	    color = darkMagenta;
	    break;
	}
	case DarkYellow:
	{
	    color = darkYellow;
	    break;
	}
    }
    
    ChangeColor( itsSelected, color );
    
    UpdateSliders( color );
    UpdateTexts( color );
}



QColor ColorSelectDialog::GetColor( void ) const
{
    return itsSelected->backgroundColor();
}
 

void ChangeColor
( 
    QWidget*		widget,
    const QColor&	color 
)
{
    widget->setPalette( QPalette( color ) );
}
