#include <qmlined.h>

#include "MultiLineEditPage.h"

#include "widget/DlgWidget.h"

#define Inherited MultiLineEditPageData

MultiLineEditPage::MultiLineEditPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QMultiLineEdit* edit = (QMultiLineEdit*)widget->GetWidget();
    
    itsText->setText( edit->text() );
    isReadOnly->setChecked( edit->isReadOnly() );
    isOverwrite->setChecked( edit->isOverwriteMode() );
}


MultiLineEditPage::~MultiLineEditPage()
{
}


void MultiLineEditPage::Apply( DlgWidget*	widget )
{
    QMultiLineEdit* edit = (QMultiLineEdit*)widget->GetWidget();
    
    edit->setText( itsText->text() );
    edit->setReadOnly( isReadOnly->isChecked() );
    edit->setOverwriteMode( isOverwrite->isChecked() );
}

