#include <qlabel.h>

#include "UserPage.h"

#include "widget/DlgUser.h"

#define Inherited UserPageData

UserPage::UserPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const DlgUser* user = (const DlgUser*) widget;
    
    itsClassName->setText( user->GetWidgetClass() );
    itsHeaderFile->setText( user->GetUserClassHeader() );
}


UserPage::~UserPage()
{
}


void UserPage::Apply( DlgWidget*	widget )
{
    DlgUser* user = (DlgUser*) widget;
    QLabel* label = (QLabel*)widget->GetWidget();
    
    user->SetUserClassName( itsClassName->text() );
    label->setText( itsClassName->text() );

    user->SetUserClassHeader( itsHeaderFile->text() );
}


