#ifndef WidgetColorPage_included
#define WidgetColorPage_included

#include <qpalette.h>

#include "WidgetColorPageData.h"

class DlgWidget;

class WidgetColorPage : public WidgetColorPageData
{
    Q_OBJECT

public:

    WidgetColorPage
    (
	DlgWidget* widget,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~WidgetColorPage();

    void Apply( DlgWidget*	widget );
    // apply changes to the widget

private slots:

    void GroupChanged( int );

    void ColorClicked();

    void FontClicked();
    

private:

    void ChangeColors( const QColorGroup&	colorGroup );
    // change the push buttons to the colors in the color group

    void SaveCurrentGroup( void );
    // save the current colors into the current color group in the palette

    void UpdateFontInfo( void );
    // update the font information based on itsFont

private:

    enum
    {
	Normal,
	Disabled,
	Active
    };

    int		itsCurrentGroup;

    QPalette	itsPalette;
    // palette for the widget

    bool	isCopy;
    // has the palette been copied from the widget

    bool	areColorsChanged;
    // have any of the colors been changed

    bool	isFontChanged;
    // has the font changed

    QFont	itsFont;
    // font for the widget

};
#endif // WidgetColorPage_included



