/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toad.hh>
#include <toad/pushbutton.hh>

class TMyWindow:
	public TWindow
{
	public:
		TMyWindow(TWindow *p, const string &t);
		void click(const char*);
};

int ToadMain()
{
  return TMyWindow(NULL, "Tool Tips").Run();
}

TMyWindow::TMyWindow(TWindow *p, const string &t):
	TWindow(p,t)
{
	bStaticFrame = true;
	SetBackground(TColor::DIALOG);
	SetToolTip("nothing to select here...");

	TPushButton *btn;
	
	btn = new TPushButton(this, "Agree");
		btn->SetShape(10,10,100,25);
		CONNECT(btn->sigActivate, this, click, "I agree!!!");
		btn->SetToolTip("You agree with the license");

	btn = new TPushButton(this, "Cancel");
		btn->SetShape(10,40,100,25);
		CONNECT(btn->sigActivate, this, click, "I'll use it anyway ;)");
		btn->SetToolTip("You dislike the license");
		
	SetSize(120,75);
}

void TMyWindow::click(const char* text)
{
	cout << "button \"" << text << "\"" << endl;
}
