/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TCheckBox
#define TCheckBox TCheckBox

#include <toad/labelowner.hh>

class TCheckBox: 
	public TLabelOwner, public TBoolManipulator
{
	typedef TLabelOwner super;

  public:
    TCheckBox(TWindow *parent, const string &title);
    ~TCheckBox();	// force vtable creation in checkbox.cc (EGCS 1.0.3a)

		template <class T>
		TCheckBox(TWindow *p, const string &t, T *d)
			:super(p,t)
		{
			_Init();
			SetData(d);
			// SetInterface(new NewBoolInterface(data));
		}
    
	private:
		void valueChanged();
    void keyDown(TKey,char*,unsigned);
    void mouseLDown(int,int,unsigned);
    void paint();

    void _Init();
};

// obsolete:
inline TCheckBox* NewCheckBox(TWindow *p, const string &t, bool *d)
{
	return new TCheckBox(p,t,d);
}

#endif
