/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef GDataStorage
#define GDataStorage GDataStorage

#include <cstdlib>
#include <new>

class Test{int x;};

template <class T>
class GDataStorage:
	public virtual TDataInterface
{
	public:
		void* Allocate() { void*p = malloc(sizeof(T)); return new(p) T(); }
		void* Pointer() const {	return (void*) _data;	}
	protected:
		T* _data;
		T* safe_cast(void* p) const { return (T*)p; }
		const T* safe_cast(const void* p) const { return (T*)p; }
};

class TStringStorage:
	public GDataStorage<string>
{
};

class TIntStorage:
	public GDataStorage<int>
{
};

class TUnsignedStorage:
	public GDataStorage<unsigned>
{
};

class TUnsignedCharStorage:
	public GDataStorage<unsigned char>
{
};

class TDoubleStorage:
	public GDataStorage<double>
{
};

class TBoolStorage:
	public GDataStorage<bool>
{
};

#endif
