/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TDragObject
#define TDragObject TDragObject

#include <string>
#include <vector>
#include <toad/toad.hh>
#include <toad/pointer.hh>

// these values might be or'ed only for TDnDObject::SetType(...)
// (or when an action is selected during TDropSite::dropRequest?)
static const unsigned ACTION_NONE			= 0;
static const unsigned ACTION_COPY			= 1;
static const unsigned ACTION_MOVE			= 2;
static const unsigned ACTION_LINK			= 4;
static const unsigned ACTION_ASK			= 8;
static const unsigned ACTION_PRIVATE	= 16;

//. see RFC 1341
class TDnDType:
	public TSmartObject
{
	public:
		TDnDType(const string &mime, unsigned actions=0);
		string mime;		// the mime type as a whole
		
		string major;		// content type
		string minor;		// sub-type
		// no MIME parameters are used for DnD
		
		bool wanted;
		unsigned actions;
};
typedef GSmartPointer<TDnDType> PDnDType;
typedef vector<PDnDType> TDnDTypeList;

struct TDnDObject:
	public TSmartObject
{
	TDnDObject();
	virtual ~TDnDObject();
	
	string flatdata;

	//. Store your data in <VAR>flatdata</VAR> using type <VAR>type</VAR>.
	virtual void flatten();
	
	TDnDTypeList typelist;
	
	PDnDType type;
	int x,y;

	void SetType(const string &mime, unsigned);

	static bool Select(TDnDObject &drop, const string &major, const string &minor);

	unsigned action;		// set by TDropSite::dropRequest
};

typedef GSmartPointer<TDnDObject> PDnDObject;

class TDropSite
{
	public:
		TDropSite(TWindow*, TRectangle const&);
		TDropSite(TWindow*);
		virtual ~TDropSite();
		
		const TRectangle& Shape();
		TWindow* Parent() { return parent; }
		
		virtual void dropRequest(TDnDObject&) = 0;
		virtual void drop(TDnDObject&) = 0;
		virtual void leave();
	protected:
		void Init();
		TWindow *parent;
		
		bool use_parent;
		TRectangle rect;
};

#endif
