/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-2000 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TForm
#define TForm TForm

// for backward compability TOAD <= 0.0.32
#define SIDE_TOP 				TFormBase::TOP
#define SIDE_BOTTOM 			TFormBase::BOTTOM
#define SIDE_LEFT   			TFormBase::LEFT
#define SIDE_RIGHT  			TFormBase::RIGHT

#define ATTACH_NONE			 	TFormBase::NONE
#define ATTACH_FORM 		 	TFormBase::FORM
#define ATTACH_WINDOW 		 	TFormBase::WINDOW
#define ATTACH_OPPOSITE_WINDOW 	TFormBase::OPPOSITE_WINDOW

class TFormBase
{
	public:
		TFormBase();
		~TFormBase();
		void AddForm(TWindow*);
		void RemoveForm(TWindow*);
		void Attach(TWindow *wnd, unsigned where, unsigned how, TWindow *which=NULL);

		void Attach(TWindow *wnd, unsigned where, TWindow *which=NULL)
		{
			Attach(wnd, where, which ? ATTACH_WINDOW : ATTACH_FORM, which);
		}
		
		void Distance(TWindow*, int distance, unsigned where=ALL);
		
		// attachment side
		static const unsigned TOP=1, BOTTOM=2, LEFT=4, RIGHT=8, ALL=15;
		// attachment method
		static const unsigned NONE=0, FORM=1, WINDOW=2, OPPOSITE_WINDOW=3;

		void AttachLast(unsigned where, unsigned how, TWindow *which=NULL);
		int nBorderOverlap;
		bool bKeepOwnBorder;
		void Arrange(int x,int y,int w,int h);

bool running;
		
	private:
		class TFormNode;
		TFormNode* _find(TWindow*);
		TFormNode *flist, *lastadd;
};

class TForm: public TWindow, public TFormBase
{
		typedef TWindow super;
	public:
		TForm(TWindow *p, const string &t="TForm"):TWindow(p,t),TFormBase(){};

	private:
		void adjust(){Arrange(0,0,Width(),Height());}
		void resize(){Arrange(0,0,Width(),Height());}
		void childNotify(TWindow *c,EChildNotify t);
};

#endif
