/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

// the implementation of TMDIWindow, TMDIArea and TMDIShell is really
// nasty (or tricky)

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/scrollbar.hh>
#include <toad/mdiwindow.hh>
#include <toad/mdishell.hh>

static const char* s_mdiarea="mdiarea";

// this class is also defined in `toadbase.cc'

class TActionDeleteWindow:
	public TAction
{
		TWindow *_window;
	public:
		TActionDeleteWindow(TWindow *w) { _window = w; }
		void execute() { delete _window; }
};


class TMDIArea: public TWindow
{
		typedef TWindow super;
	public:
		TMDIArea(TMDIWindow* w,const string &t=s_mdiarea)
			:super(w,t){SetBorder(false); bFocusManager=true;}
		int x1,y1,x2,y2;		// virtual area (depends on child windows)
		void calculate_va();	// calculate virtual area
	private:
		void childNotify(TWindow*,EChildNotify);
};

class TMDIWindow::TMDIVScrollBar:public TVScrollBar
{
	public:
		TMDIVScrollBar(TWindow* p, const string &t)
			:TVScrollBar(p,t){}
	protected:
};

class TMDIWindow::TMDIHScrollBar:public THScrollBar
{
	public:
		TMDIHScrollBar(TWindow* p, const string &t)
			:THScrollBar(p,t){}
	protected:
};

/*****************************************************************************
 *                                                                           *
 * TMDIWindow																																 *
 *                                                                           *
 *****************************************************************************/
//! TMDIWindow
//. An easy to handle Multiple Document Interface (MDI) implementation.<BR>
//. Basicly it's a small window manager which resides in a window of your
//. program.<P>
//. <I>Note: Windows added to TMDIWindow won't become direct children of
//. TMDIWindow. The two windows between them are the MDI area and the shell
//. window. But normaly you can ignore this behaviour.</I>

// constructor
//---------------------------------------------------------------------------
TMDIWindow::TMDIWindow(TWindow *p,const string &t)
	:TWindow(p,t)
{
	SetBackground(TColor::DIALOG);
	bAddLock = true;
	area = new TMDIArea(this);
	bAddLock = false;
	area->SetBackground(TColor::MDIAREA);
	hscroll=NULL;
	vscroll=NULL;
}

// resize
//---------------------------------------------------------------------------
void TMDIWindow::resize()
{
	area->calculate_va();
}

/*---------------------------------------------------------------------------*
 | signal handler                                                            |
 *---------------------------------------------------------------------------*/
void TMDIWindow::actHScroll(TScrollBar *sb)
{
	TWindow *p = area->FirstChild();
	while(p)
	{
		p->SetSuppressMessages(true);	// still needed?
		p->SetPosition(p->XPos()-sb->Value(), p->YPos());
		p->SetSuppressMessages(false);
		p = NextSibling(p);
	}
	area->calculate_va();
}

void TMDIWindow::actVScroll(TScrollBar *sb)
{
	TWindow *p = area->FirstChild();
	while(p)
	{
		p->SetSuppressMessages(true);   // still needed?
		p->SetPosition(p->XPos(), p->YPos()-sb->Value());
		p->SetSuppressMessages(false);
		p = NextSibling(p);
	}
	area->calculate_va();
}

// vaChanged
//---------------------------------------------------------------------------
void TMDIWindow::vaChanged()
{
	int w = _w;
	int h = _h;
	TRectangle r;
	
	bool hf,vf;

	if (area->y1<0 || area->y2>h)
	{
		vf = true;
		if (!vscroll)
		{
			bAddLock=true;
			vscroll = new TMDIVScrollBar(this,"");
			bAddLock=false;
			OLD_CONNECT(this,actVScroll, vscroll,vscroll->sigValueChanged);
		}
		vscroll->GetShape(&r);
		w -= r.w;
	}
	else
	{
		vf = false;
	}
	
	if (area->x1<0 || area->x2>w)
	{
		hf = true;
		if (!hscroll)
		{
			bAddLock = true;
			hscroll = new TMDIHScrollBar(this,"");
			bAddLock = false;
			OLD_CONNECT(this,actHScroll, hscroll,hscroll->sigValueChanged);
		}
		TRectangle r;
		hscroll->GetShape(&r);
		h -= r.h;
	}
	else
	{
		hf = false;
	}
	
	if ( !vf && (area->y1<0 || area->y2>h) )
	{
		vf = true;
		TRectangle r;
		if (!vscroll)
		{
			bAddLock = true;
			vscroll = new TMDIVScrollBar(this,"");
			bAddLock = false;
			OLD_CONNECT(this,actVScroll, vscroll,vscroll->sigValueChanged);
		}
		vscroll->GetShape(&r);
		w -= r.w;
	}

	if (area->x2<w)
		area->x2=w;
		
	if (area->y2<h)
		area->y2=h;
		
	area->SetShape(0,0,w,h);

	if (vf)
	{
		vscroll->SetRange(area->y1,area->y2-1);
		vscroll->SetVisible(h);
		vscroll->SetValue(0);
		vscroll->SetShape(w,-1,TSIZE_PREVIOUS,h+1);
		if (!vscroll->IsRealized()) vscroll->Create();
	}
	else
	{
		if (vscroll) {
			SendMessage(new TActionDeleteWindow(vscroll));
		}
	}

	if (hf)
	{
		hscroll->SetRange(area->x1,area->x2-1);
		hscroll->SetVisible(w);
		hscroll->SetValue(0);
		hscroll->SetShape(-1,h,w+1,TSIZE_PREVIOUS);
		if (!hscroll->IsRealized()) hscroll->Create();
	}
	else
	{
		if (hscroll) {
			SendMessage(new TActionDeleteWindow(hscroll));
		}
	}
//	printf("TMDIWindow::vaChanged done\n");
}

// childNotify
//---------------------------------------------------------------------------
void TMDIWindow::childNotify(TWindow *wnd,EChildNotify type)
{
	switch(type)
	{
		case TCHILD_BEFORE_ADD:
			if (!bAddLock)
			{
				TMDIShell *shell = new TMDIShell(area,wnd->Title());
				shell->AddChild(wnd);
				// a thing we also have to do is
				//    wnd->bShell = false;
				// but we can't do it here, because we're called from
				// wnds' TWindow::TWindow constructor and bShell might
				// be set to true later, e.g. by TDialog::TDialog.
				// So the 'bShell' flag is removed by TMDIShell when
				// it gets the childs TCHILD_BEFORE_CREATE message.
			}
			break;
		case TCHILD_REMOVE:
			if (wnd==vscroll)
				vscroll=NULL;
			if (wnd==hscroll)
				hscroll=NULL;
			break;
		default:;
	}
}

/*****************************************************************************
 *                                                                           *
 * TMDIArea																																	 *
 *                                                                           *
 *****************************************************************************/

/*---------------------------------------------------------------------------*
 | childCreate	                                                             |
 *---------------------------------------------------------------------------*/
void TMDIArea::childNotify(TWindow *wnd,EChildNotify type)
{
	switch(type)
	{
		case TCHILD_CREATE:
			wnd->SetFocus();
			calculate_va();
			break;
		case TCHILD_DESTROY:
#ifdef DONT_NEED_THIS_ANYMORE
			if(IsPartOfFocus(wnd))
			{
				TWindow *ptr;
				ptr=FirstChild();
				while(ptr)
				{
					if (/* !IsPartOfFocus(ptr) && ptr->_bFocus*/ && ptr->IsRealized())
					{
						ptr->SetFocus();
						return;
					}
					ptr=NextSibling(ptr);
				}
				/* SetFocus(NULL); */
			}
#endif
			calculate_va();
			break;
		case TCHILD_POSITION:
		case TCHILD_RESIZE:
			calculate_va();
			break;
		default:;
	}
}

/*---------------------------------------------------------------------------*
 | calculate_va()		                                                         |
 *---------------------------------------------------------------------------*/
void TMDIArea::calculate_va()
{
	int nx1,ny1,nx2,ny2;
	nx1=ny1=nx2=ny2=0;
	
	TWindow *ptr=FirstChild();
	while(ptr)
	{
		if (ptr->IsRealized())
		{
			TRectangle shape;
			ptr->GetShape(&shape);
			if (shape.x < nx1)
				nx1=shape.x;
			if (shape.x+shape.w > nx2)
				nx2=shape.x+shape.w;
			if (shape.y < ny1)
				ny1=shape.y;
			if (shape.y+shape.h > ny2)
				ny2=shape.y+shape.h;
		}
		ptr=NextSibling(ptr);
	}
//	if (nx1!=x1 || ny1!=y1 || nx2!=x2 || ny2!=y2)
	{
		x1=nx1; y1=ny1; x2=nx2; y2=ny2;
		static_cast<TMDIWindow*>(Parent())->vaChanged();
	}
}
