/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TTextField
#define TTextField TTextField

#include <toad/control.hh>

class TDropString;

class TTextField: public TControl, public TStringManipulator
{
		typedef TControl super;

	public:
		TTextField(TWindow*, const string&);
		~TTextField();

		template <class T>
		TTextField(TWindow *p, const string &t, T *d)
			:super(p,t)
		{
			_Init();
			SetInterface(NewStringInterface(d));
			// SetData(d); // EGCS 1.0.3a: Internal compiler error
		}

		bool bPassword;
		TSignal sigActivate;	// more to come?
		
	protected:
		void paint();
		void focus();
		void enabled();
		void mouseLDown(int,int,unsigned);
//		void mouseMDown(int,int,unsigned);
		void keyDown(TKey,char*,unsigned);
//		void dropInsert(TDropString*);
		void valueChanged();
		
	private:
		void _Init();
		unsigned ml, mr;		// marked area
		unsigned cx, left;
};

template <class T>
TTextField* NewTextField(TWindow *p, const string &t, T *d) {
	return new TTextField(p,t,d);
}

#endif
