/* $Id: List.h,v 1.1.1.1 2001/04/09 13:32:42 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_list_h)
#define xarm_list_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>
#include <Xm/List.h>

class ListClass : public PrimitiveClass {
 protected:
   ListClass() {} 
   virtual WidgetClass classPointer()   { return xmListWidgetClass; }
   virtual _XtString className()        { return (_XtString) "XmList"; }
 public:
   /* callbacks */
   void browseSelectionCallback(XtCallbackProc fp, XtPointer data = NULL)
                             { XARM_SET_CALLBACK(XmNbrowseSelectionCallback); }
   void defaultActionCallback(XtCallbackProc fp, XtPointer data = NULL)
                             { XARM_SET_CALLBACK(XmNdefaultActionCallback); }
   void extendedSelectionCallback(XtCallbackProc fp, XtPointer data = NULL)
                             { XARM_SET_CALLBACK(XmNextendedSelectionCallback); }
   void multipleSelectionCallback(XtCallbackProc fp, XtPointer data = NULL)
                             { XARM_SET_CALLBACK(XmNmultipleSelectionCallback); }
   void singleSelectionCallback(XtCallbackProc fp, XtPointer data = NULL)
                             { XARM_SET_CALLBACK(XmNsingleSelectionCallback); }

   /* convenience routines */

   /* resources */
   void automaticSelection(Boolean val)            { XARM_SET_VALUE(XmNautomaticSelection); }
   Boolean automaticSelection() const              { XARM_GET_VALUE(Boolean, XmNautomaticSelection); }
   void doubleClickInterval(int val)               { XARM_SET_VALUE(XmNdoubleClickInterval); }
   int doubleClickInterval() const                 { XARM_GET_VALUE(int, XmNdoubleClickInterval); }
   void fontList(const XmFontList val)             { XARM_SET_VALUE(XmNfontList); }
   XmFontList fontList() const                     { XARM_GET_VALUE(XmFontList, XmNfontList); }
   void itemCount(int val)                         { XARM_SET_VALUE(XmNitemCount); }
   int itemCount() const                           { XARM_GET_VALUE(int, XmNitemCount); }
   void items(const XmStringTable val)             { XARM_SET_VALUE(XmNitems); }
   XmStringTable items() const                     { XARM_GET_VALUE(XmStringTable, XmNitems); }
   void listMarginHeight(Dimension val)            { XARM_SET_VALUE(XmNlistMarginHeight); }
   Dimension listMarginHeight() const              { XARM_GET_VALUE(Dimension, XmNlistMarginHeight); }
   void listMarginWidth(Dimension val)             { XARM_SET_VALUE(XmNlistMarginWidth); }
   Dimension listMarginWidth() const               { XARM_GET_VALUE(Dimension, XmNlistMarginWidth); }
   unsigned char listSizePolicy() const            { XARM_GET_VALUE(Dimension, XmNlistSizePolicy); }
   void listSpacing(Dimension val)                 { XARM_SET_VALUE(XmNlistSpacing); }
   Dimension listSpacing() const                   { XARM_GET_VALUE(Dimension, XmNlistSpacing); }
   void scrollBarDisplayPolicy(unsigned char val)  { XARM_SET_VALUE(XmNscrollBarDisplayPolicy); }
   unsigned char scrollBarDisplayPolicy() const    { XARM_GET_VALUE(unsigned char, XmNscrollBarDisplayPolicy);}
   void selectedItemCount(int val)                 { XARM_SET_VALUE(XmNselectedItemCount); }
   int selectedItemCount() const                   { XARM_GET_VALUE(int, XmNselectedItemCount); }

   // The following functions have been replaced!!!
   // void selectedItems(const XmStringTable val)     { XARM_SET_VALUE(XmNselectedItems); }
   // XmStringTable selectedItems() const             { XARM_GET_VALUE(XmStringTable, XmNselectedItems); }
   // The selectedItems(const char **) function requires a NULL terminator
   // The char **selectedItems() will return an array of char *'s that is NULL terminated.
   // Use the function freeSelectedItems() to free the memory allocated by char **selectedItems().
   void   selectedItems(const char **items);
   char **selectedItems() const;
   void   freeSelectedItems(char **items) const;

   void selectionPolicy(unsigned char val)         { XARM_SET_VALUE(XmNselectionPolicy); }
   unsigned char selectionPolicy() const           { XARM_GET_VALUE(unsigned char, XmNselectionPolicy); }
   void stringDirection(XmStringDirection val)     { XARM_SET_VALUE(XmNstringDirection); }
   XmStringDirection stringDirection() const       { XARM_GET_VALUE(XmStringDirection, XmNstringDirection); }
   void topItemPosition(int val)                   { XARM_SET_VALUE(XmNtopItemPosition); }
   int topItemPosition() const                     { XARM_GET_VALUE(int, XmNtopItemPosition); }
   void visibleItemCount(int val)                  { XARM_SET_VALUE(XmNvisibleItemCount); }
   int visibleItemCount() const                    { XARM_GET_VALUE(int, XmNvisibleItemCount); }

   /* extra functionality */
   void add(const char *);  /* adds an item to the list box */
   void add(const char ** l, int c); /* [][]= { "foo","yo" }; */
   void clear()     /* clears out the list box */        { XmListDeleteAllItems(widget()); }
   int count() const { XARM_GET_VALUE(int, XmNitemCount); }
   void del(int p)   /* deletes an item at position p */ { XmListDeletePos(widget(), p); }
   void del(int n,int p) /* deletes n items starting at position p */ { XmListDeleteItemsPos(widget(), n, p); }
   void del(const char *);
   void del(const char **, int); /* [][]= { "foo","yo" }; */
   void deselect(const char *);
   void deselect(int p)                                  { XmListDeselectPos(widget(), p); }
   void deselectAll()                                    { XmListDeselectAllItems(widget()); }
   int exists(const char *); /* does the item exists in the list */
   void insert(const char * s, int p);  /* inserts an item at a location */
   void insert(const char ** l, int c, int p); /* [][]= {"foo","yo" }; */
   int item(const char *s); /* returns the position of s */
   void horizontal(int p) /* position of the scroll bar */ { XmListSetHorizPos(widget(), p); }
   int match(const char *item, int *&p, int &c); 
   void replace(const char **n, int c, int p);
   void replace(const char **o, int c, const char **n); /* replace old items w/ new */
   Boolean selected(int *&slist, int &snum) /* returns the selected items, delete array */
               { return XmListGetSelectedPos(widget(), &slist, &snum); }
   void select(const char *s, int notify); /* selects the item in the list */
   void select(int p, int notify); /* selects the item at that position */
   void set(const char *); /* sets the item to be the first visible item if posible */
   void set(int p) /* sets the item to be the first visible item if posible */ { XmListSetPos(widget(), p); }
   void setBottom(const char *);
   void setBottom(int p)                                 { XmListSetBottomPos(widget(), p); }
   
};

typedef XarmRawWidget<ListClass, false> List;

typedef XarmFuncWidget<ListClass, XmCreateScrolledList, true> ScrolledList;

#endif
