/* $Id: ComboBox.C,v 1.1.1.1 2001/04/09 13:34:36 glgay Exp $ */
/*
 Copyright (C) 1996       Peter Williams
 Copyright (C) 1997, 1999 Gerald L. Gay

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ComboBox.h>

/*
* The ComboBox only exists in versions of Motif >= 2.
* However, you could write one yourself and remove this restriction.
*/
#if XmVERSION >= 2 && ! defined(XARM_HAS_CDE)

#include <Xm/ComboBoxP.h>

#if !defined(CB_List)
#define CB_List(w) \
	(((XmComboBoxWidget)(w))->combo_box.list)
#endif

/* convenience routines */
Widget
ComboBoxClass::list() const
{
   return (Widget) CB_List(widget());
}

void
ComboBoxClass::update()
{
   XmComboBoxUpdate(widget());
}

void ComboBoxClass::add(const char *str)
{
    ListClass *theList = listObject();
    if (theList != NULL) {
        theList->add(str);
	update();
    }
}

void ComboBoxClass::clear()
{
    ListClass *theList = listObject();
    if (theList != NULL) {
	theList->clear();
	update();
    }
}
   
/* extras */
/* This is how you wrap existing widgets. */

ListClass *
ComboBoxClass::listObject() const
{
   ListClass *foo; 

   foo = (ListClass *) WidgetToWObject(list());   
   if (foo == NULL)
   {  /* then no wrap yet so wrap it */
      foo = new XarmWidget<ListClass>(list());
   }
   return foo;
}

#endif
