/* $Id: XarmMatrix.C,v 1.1.1.1 2001/04/09 13:35:07 glgay Exp $ */
/*
 Copyright (C) 1999, Phil Grim

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/XarmMatrix.h>

#if defined(XARM_HAS_XBAE)

//
// Additional functionality
//
#define  THRESH      7    /* subfiles of T or fewer elements will */
                          /* be sorted by a simple insertion sort */
                          /* Note!  T must be at least 3          */
static void swap_chars(char *, char *, size_t);
static int compare_elements(void *, void *, int, int);

bool MatrixClass::sort(int column, int direction)
{
   char    *stack[40], **sp;                      // stack and stack pointer
   char    *i, *j, *limit;                        // scan and limit pointers
   size_t   thresh;                               // size of T elements in bytes
   char    *base;                                 // base pointer as char *
   size_t   nelems = (size_t)rows();
   size_t   size = sizeof(String *);
   String **stuff = NULL;

   stuff = cells();

   base   = (char *)stuff;
   thresh = THRESH * size;
   sp     = stack;
   limit  = base + nelems * size;
   for ( ;; ) {
       if ( (size_t)(limit - base) > thresh ) {
           swap_chars((((limit-base)/size)/2)*size+base, base, size);
           i = base + size;
           j = limit - size;
           if (compare_elements((void *)i, (void *)j, column, direction) > 0 )
               swap_chars(i, j, size);
           if (compare_elements((void *)base, (void *)j,
                                column, direction) > 0 )
               swap_chars(base, j, size);
           if (compare_elements((void *)i, (void *)base,
                                 column, direction) > 0 )
               swap_chars(i, base, size);
           for ( ;; ) {
              do
                 i += size;
              while ( compare_elements((void *)i, (void *)base,
                                        column, direction) < 0 );
              do
                 j -= size;
              while ( compare_elements((void *)j, (void *)base,
                                        column, direction) > 0 );
              if ( i > j )
                 break;
              swap_chars(i, j, size);
           }
           swap_chars(base, j, size);
           if ( j - base > limit - i ) {
               sp[0] = base;
               sp[1] = j;
               base  = i;
           } else {
              sp[0] = i;
              sp[1] = limit;
              limit = j;
           }
           sp += 2;
        } else {
            for ( j = base, i = j+size; i < limit; j = i, i += size )
            for (; compare_elements((void *)j, (void *)(j+size),
                 column, direction) > 0; j -= size ) {
               swap_chars(j, j+size, size);
               if ( j == base )
                  break;
            }
         if ( sp != stack ) {
            sp -= 2;
            base = sp[0];
            limit = sp[1];
         } else
            break;
      }
   }

    cells(stuff);
    return true;
}

/*******************************************************************************
*
*   Function: swap_chars
*   Author:   Phil Grim
*
*   Abstract:
*       This function swaps bytes in memory
*
*   Returns:
*       This function returns nothing
*
*******************************************************************************/
static void swap_chars(char *a, char *b, size_t nbytes)
{
   char tmp;
   do {
      tmp = *a; *a++ = *b; *b++ = tmp;
   } while ( --nbytes );
}

/*******************************************************************************
*
*   Function: compare_elements
*   Author:   Phil Grim
*
*   Abstract:
*       This function compares two rows of strings based on a column
*
*   Returns:
*       This function returns lex order, modified by direction
*
*******************************************************************************/
static int compare_elements(void *elem1, void *elem2, int col, int direction)
{
    int      result = 0;
    String **str1   = (String **)elem1;
    String **str2   = (String **)elem2;

    result = strcmp((*str1)[col], (*str2)[col]);
 
    if (direction)
        result *= -1;

    return result;
}

#endif // XARM_HAS_XBAE
