/****************************************************************************
** $Id: qvalidator.h,v 2.9 1997/09/04 16:40:25 agulbra Exp $
**
** Definition of validator classes.
**
** Created : 970610
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QVALIDATOR_H
#define QVALIDATOR_H

#include "qobject.h"
#include "qstring.h"


class QValidator: public QObject
{
    Q_OBJECT
public:
    QValidator( QWidget * parent, const char * name = 0 );
    ~QValidator();

    enum State { Invalid, Valid, Acceptable };

    virtual State validate( QString &, int & ) = 0;
    virtual void fixup( QString & );
};


class QIntValidator: public QValidator
{
    Q_OBJECT
public:
    QIntValidator( QWidget * parent, const char * name = 0 );
    QIntValidator( int bottom, int top,
		   QWidget * parent, const char * name = 0 );
    ~QIntValidator();

    QValidator::State validate( QString &, int & );

    virtual void setRange( int bottom, int top );

    int bottom() const { return b; }
    int top() const { return t; }
    
private:
    int b, t;
};


class QDoubleValidator: public QValidator
{
    Q_OBJECT
public:
    QDoubleValidator( QWidget * parent, const char * name = 0 );
    QDoubleValidator( double bottom, double top, int decimals,
		      QWidget * parent, const char * name = 0 );
    ~QDoubleValidator();

    QValidator::State validate( QString &, int & );

    virtual void setRange( double bottom, double top, int decimals = 0 );

    double bottom() const { return b; }
    double top() const { return t; }
    int decimals() const { return d; }
    
private:
    double b, t;
    int d;
};


#endif // QVALIDATOR_H
