#include "Toolbar.h"

#define Inherited QButtonGroup


Toolbar::Toolbar
(
 QWidget*	parent,
 const char*	name
 )
  :
  Inherited( parent, name ),
  itsSize( 3, 0 ),
  itsToolTipGroup( this )
{
  setExclusive( TRUE );
  itsButtonList.setAutoDelete( FALSE );

  setFrameStyle( WinPanel | Raised );
  resize( width(), 32 );
}


Toolbar::~Toolbar()
{
}


uint Toolbar::Insert
(
    const QPixmap&	pixmap,
    const QObject*	receiver,
    const char*		slot,
    const char*		toolTip,
    const char*		longToolTip,
    const char*   name,
    const bool    toggle
)
{
  return Insert( -2, pixmap, receiver, slot, 
                 toolTip, longToolTip, name, toggle );
}

uint Toolbar::Insert
(
 const int       id,
 const QPixmap&	pixmap,
 const QObject*	receiver,
 const char*		slot,
 const char*		toolTip,
 const char*		longToolTip,
 const char*   name,
 const bool    toggle
 )
{
  QPushButton* button = new QPushButton( this, name );
  int retId = insert( button, id );

  button->setPixmap( pixmap );
  button->adjustSize();
  button->move( itsSize.width(), 3 );
  button->setToggleButton( toggle );
  itsSize.rwidth() += button->width();
  itsSize.rheight() = button->height() > itsSize.height() ? 
    button->height() : itsSize.height();

  resize( itsSize.width() + 3, itsSize.height() + 6 );
    
  if( receiver && slot )
  {
    receiver->connect( button, SIGNAL(clicked()), slot );
  }

  if( toolTip )
  {
    if( longToolTip )
    {
	    QToolTip::add( button, toolTip, &itsToolTipGroup, longToolTip );
    }
    else
    {
	    QToolTip::add( button, toolTip );
    }
  }

  itsButtonList.append( button );
  return retId;
}


void Toolbar::EnableItem
(
 uint	item,
 bool	enable
 )
{
  QButton* button = find( item );
  if( button )
  {
    button->setEnabled( enable );
  }
}

void Toolbar::ToggleItem
(
 uint	item
 )
{
  QPushButton* button;

  // Set all buttons off
  for( button = itsButtonList.first();
       button;
       button = itsButtonList.next() )
  {
    button->setOn( FALSE );
  }

  button = (QPushButton *) find( item );
  if( button )
  {
    button->setOn( TRUE );
  }
}



