#include "layout/BoxStretch.h"
#include "layout/BoxStretchPropPage.h"

#include "WidgetLayout.h"
#include "GuiTools.h"

#define Inherited LayoutItem

BoxStretch::BoxStretch
(
    QWidget*		parent,
    WidgetLayout*	widgetLayout,
    int			stretch
)
    :
    Inherited( widgetLayout ),
    itsFrame( NULL ),	
    itsStretch( stretch )
{
    itsFrame = new Frame( parent, NULL );
    itsFrame->setFrameStyle( QFrame::Panel | QFrame::Plain );
    SetColor( itsFrame );
    itsFrame->show();
    
    widgetLayout->connect( itsFrame, SIGNAL(MousePress(QWidget*,QMouseEvent*)),
			   SLOT(LayoutMousePress(QWidget*,QMouseEvent*)) );
    widgetLayout->connect( itsFrame, SIGNAL(Paint(QWidget*)),
			   SLOT(LayoutPaint(QWidget*)) );
    widgetLayout->connect( 
	itsFrame, 
	SIGNAL(MouseDoubleClick(QWidget*,QMouseEvent*)),
	SLOT(ProcessMouseDoubleClick(QWidget*,QMouseEvent*)) );
}


BoxStretch::~BoxStretch()
{
    itsFrame->parent()->removeChild( itsFrame );
    delete itsFrame;
}


void BoxStretch::AddToLayout
(
    QBoxLayout*	layout
)
{
    layout->addWidget( itsFrame, itsStretch );
}


LayoutItem* BoxStretch::FindLayoutItem
(
    QWidget*	widget
) const
{
    return (widget == itsFrame) ? this : (LayoutItem*)NULL;
}


void BoxStretch::LowerWidget( void )
{
    itsFrame->lower();
}


void BoxStretch::SaveContents( QTextStream&	stream,
			       QString		id ) const
{
    stream << GetItemName() << "-" << id << "{\n";
    
    stream << "\t\tStretch {" << itsStretch << "}\n";
    
    stream << "}\n";
}


bool BoxStretch::RestoreKeyValue( const QString&	key,
				  const QString&	value )
{
    bool rc = TRUE;
    
    if( key == "Stretch" )
    {
	itsStretch = value.toInt();
    }
    else 
    {
	rc = FALSE;
    }
    
    return rc;
}


void BoxStretch::GenerateSource( QTextStream&	stream,
				 const QString&	layoutVarName,
				 const QString&	/*layoutId*/ ) const
{
    stream << '\t' << layoutVarName << "->addStretch( " << itsStretch << 
	" );\n";
}


QString BoxStretch::GetItemName( void ) const
{
    return ItemName();
}


QWidget* BoxStretch::GetPropertyPage
(
    QWidget*	parent
)
{
    return new BoxStretchPropPage( this, parent, GetItemName() );
}


QRect BoxStretch::GetGlobalGeometry( void ) const
{
    return GuiTools::GetGlobalGeometry( itsFrame );
}
