#include <qcombo.h> 
#include <qstring.h>

#include "ComboBoxPage.h"

#include "widget/DlgWidget.h"
#include "widget/DlgComboBox.h"

#include "GuiTools.h"

#define Inherited ComboBoxPageData

ComboBoxPage::ComboBoxPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    const QComboBox* combo = (const QComboBox*)widget->GetWidget();
    const DlgComboBox* dlgCombo = (const DlgComboBox*)widget;
	
    connect( itsNewButton, SIGNAL(clicked()), SLOT(NewClicked()) );
    connect( itsChangeButton, SIGNAL(clicked()), SLOT(ChangeClicked()) );
    connect( itsDeleteButton, SIGNAL(clicked()), SLOT(DeleteClicked()) );
    connect( itsList, SIGNAL(highlighted(int)), 
	     SLOT(ListSelChanged(int)) );
    connect( itsNewLine, SIGNAL(textChanged(const char*)),
	     SLOT(NewItemChanged(const char*)) );
    connect( itsStyleGroup, SIGNAL(clicked(int)), 
	     SLOT(StyleChanged(int)) );

    GuiTools::TransferListFromCombo( combo, itsList );

    switch( dlgCombo->GetComboType() )
    {
	case DlgComboBox::CT_ReadOnly:
	default:
	{
	    isStyleRO->setChecked( TRUE );
	    break;
	}
	case DlgComboBox::CT_ReadWrite:
	{
	    isStyleRW->setChecked( TRUE );
	    break;
	}
	case DlgComboBox::CT_Motif1x:
	{
	    isStyleOld->setChecked( TRUE );
	    break;
	}
    }

    QString str;

    itsSizeLimit->setText( str.setNum( combo->sizeLimit() ) );
    itsPolicy->setCurrentItem( combo->insertionPolicy() );
    isAutoResize->setChecked( combo->autoResize() );

    Update();
}


ComboBoxPage::~ComboBoxPage()
{
}


void ComboBoxPage::Apply( DlgWidget*	widget )
{
    QComboBox* combo = (QComboBox*)widget->GetWidget();
    DlgComboBox* dlgCombo = (DlgComboBox*)widget;
    
    GuiTools::TransferListToCombo( combo, itsList );

    DlgComboBox::ComboType type = DlgComboBox::CT_Motif1x;
    if( isStyleRO->isChecked() )
    {
	type = DlgComboBox::CT_ReadOnly;
    }
    else if( isStyleRW->isChecked() )
    {
	type = DlgComboBox::CT_ReadWrite;
    }
    
    dlgCombo->SetComboType( type );

    QString str = itsSizeLimit->text();
    combo->setSizeLimit( str.toInt() );
    combo->setInsertionPolicy( (QComboBox::Policy)
			       itsPolicy->currentItem() );
    combo->setAutoResize( isAutoResize->isChecked() );
}


void ComboBoxPage::NewClicked()
{
    const char* text = itsNewLine->text();
    if( text && text[0] )
    {
	itsList->insertItem( text );
    }
}


void ComboBoxPage::ChangeClicked()
{
    const char* text = itsNewLine->text();
    if( text && text[0] )
    {
	itsList->changeItem( text, itsList->currentItem() );
    }
}


void ComboBoxPage::DeleteClicked()
{
    int item = itsList->currentItem();
    if( item >= 0 )
    {
	itsList->removeItem( item );
	Update();
    }
}


void ComboBoxPage::ListSelChanged( int item )
{
    itsNewLine->setText( itsList->text( item ) );
    Update();
}


void ComboBoxPage::NewItemChanged( const char* )
{
    Update();
}


void ComboBoxPage::StyleChanged( int )
{
    Update();
}


void ComboBoxPage::Update()
{
    const char* text = itsNewLine->text();
    bool newText = ( text && text[0] );
    bool itemSelected = (itsList->currentItem() != -1);

    itsNewButton->setEnabled( newText );
    itsChangeButton->setEnabled( newText & itemSelected );
    itsDeleteButton->setEnabled( itemSelected );

    bool enableLines = FALSE;
    bool enableInsert = FALSE;

    if( isStyleRO->isChecked() )
    {
	enableLines = TRUE;
    }
    else if( isStyleRW->isChecked() )
    {
	enableLines = TRUE;
	enableInsert = TRUE;
    }
    
    itsSizeLimitLabel->setEnabled( enableLines );
    itsSizeLimit->setEnabled( enableLines );
    itsPolicyLabel->setEnabled( enableInsert );
    itsPolicy->setEnabled( enableInsert );
}


