#include <qmsgbox.h>

#include "widget/SignalConnection.h"

#include "prop/SignalSelectDialog.h"

#define Inherited SignalSelectDialogData

SignalSelectDialog::SignalSelectDialog
(
    const QStrList& signalList,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    setCaption( "Signal / Slot Connection" );

    itsSignals->insertStrList( &signalList );

    connect( itsSignals, SIGNAL(highlighted(int)), SLOT(SignalChanged(int)) );
    connect( itsSlot, SIGNAL(textChanged(const char*)), 
	     SLOT(SlotChanged(const char*)) );
    connect( itsOkButton, SIGNAL(clicked()), SLOT(accept()) );
    connect( itsCancelButton, SIGNAL(clicked()), SLOT(reject()) );
    
    Update();
}


SignalSelectDialog::~SignalSelectDialog()
{
}


void SignalSelectDialog::SignalChanged( int )
{
    Update();
}


void SignalSelectDialog::SlotChanged( const char* )
{
    Update();
}


void SignalSelectDialog::Update()
{
    bool enable = (itsSignals->currentItem() != -1);
    
    itsAccessBox->setEnabled( enable );
    isBaseClass->setEnabled( enable );
    isProtected->setEnabled( enable );
    isPublic->setEnabled( enable );
    itsSlotLabel->setEnabled( enable );
    itsSlot->setEnabled( enable );

    QString str = itsSlot->text();
    itsOkButton->setEnabled( enable && !str.isEmpty() );
}


void SignalSelectDialog::SetData( const SignalConnection&	sig )
{
    unsigned int i;
    bool found = FALSE;
    QString sigStr = sig.GetSignal();
    
    for( i = 0; (i < itsSignals->count()) && !found; i++ )
    {
	if( sigStr == itsSignals->text( i ) )
	{
	    found = TRUE;
	}
    }
    
    if( found )
    {
	itsSignals->setCurrentItem( i-1 );
    }
    else
    {
	QString str = "Signal " + sigStr + " not found for this widget";
	QMessageBox::message( "Warning", str );
    }

    itsSlot->setText( sig.GetSlotName() );
    
    isProtected->setChecked( FALSE );
    isPublic->setChecked( FALSE );

    switch( sig.GetScope() )
    {
	case SignalConnection::BaseClass:
	{
	    isBaseClass->setChecked( TRUE );
	    break;
	}
	case SignalConnection::Protected:
	{
	    isProtected->setChecked( TRUE );
	    break;
	}
	case SignalConnection::Public:
	{
	    isPublic->setChecked( TRUE );
	    break;
	}
    }

    Update();
}


void SignalSelectDialog::GetData( SignalConnection&	sig ) const
{
    QString sigstr = itsSignals->text( itsSignals->currentItem() );

    sig.SetSignal( sigstr );
    sig.SetSlotName( itsSlot->text() );
    
    SignalConnection::Scope scope = SignalConnection::Protected;
    if( isPublic->isChecked() )
    {
	scope = SignalConnection::Public;
    } else if( isBaseClass->isChecked() )
    {
	scope = SignalConnection::BaseClass;
    }
    
    sig.SetScope( scope );
}
