#ifndef ComboBox_included
#define ComboBox_included

#include <qcombo.h>

class ComboBox : public QComboBox
{
    Q_OBJECT
    
public:
    
    ComboBox
    (
	QWidget*	widget,
	const char*	name
    );


signals:

    void MousePress
    (
	QWidget*	widget,
	QMouseEvent*	event
    );

    void MouseDoubleClick( QWidget*	widget,
			   QMouseEvent*	event );

    void MouseMove
    (
	QWidget*	widget,
	QMouseEvent*	event
    );
    
    void MouseRelease();
    
    void Paint
    (
	QWidget*	widget
    );
    
    void Resize
    (
	QWidget*	widget,
	QResizeEvent*	event
    );

    void Move
    (
	QWidget*	widget,
	QMoveEvent*	event
    );
        
    
protected: // methods

    virtual void mousePressEvent
    ( 
	QMouseEvent*	event 
    );

    virtual void mouseDoubleClickEvent( QMouseEvent*	event );

    virtual void mouseMoveEvent
    (
	QMouseEvent*	event
    );

    virtual void mouseReleaseEvent
    (
	QMouseEvent*	//event
    );
        
    virtual void paintEvent
    (
	QPaintEvent*	event
    );

    virtual void resizeEvent
    (
	QResizeEvent*	event
    );

    virtual void moveEvent
    (	
	QMoveEvent*	event
    );
};


#endif // ComboBox_included
