/*
 * TGhostscript -- an experimental TPen to ghostscript converter
 * Copyright (C) 1997 by Mark-Andr Hopf
 * This file is part of the TOAD GUI Toolkit
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <toad/toad.hh>

class TGhostPen: public TPenBase
{
		string filename;
		FILE *fd;
		const int top = 500;
		const int left = 50;
	public:
		void Open(const string&);
		void Close();
		void SetColor(short r,short g,short b);
		void DrawLine(int,int,int,int);
		void DrawLines(TPoint *points, int n){};
		void DrawRectangle(int x,int y,int w,int h);
    void DrawCircle(int x,int y,int w,int h){};
    void DrawArc(int,int,int,int,double,double){};
    void FillRectangle(int x,int y,int w,int h);
    void FillPolygon(TPoint *points, int n){};
    void DrawPolygon(TPoint *points, int n){};
    void FillCircle(int x,int y,int w,int h){};

		void DrawPoint(int, int){}
		void ClrClipBox(){}
		void GetClipBox(struct TRect *){}
};

class TMyWindow: public TWindow
{
	public:
		TMyWindow(TWindow *p, const string &t): TWindow(p,t){};
		void Print(TPenBase&);
	protected:
		void paint(TPen&);
};
                
int ToadMain()
{
	TMyWindow wnd(NULL, "TGhostScript");
	TGhostPen gpen;
	
	gpen.Open("test.ps");
	wnd.Print(gpen);
	gpen.Close();
	
  return wnd.Run();
}

void TMyWindow::paint(TPen &pen)
{
	Print(pen);
}

void TMyWindow::Print(TPenBase &pen)
{
	pen.SetColor(0,0,255);
	pen.FillRectangle(0,0,320,200);
	for(int i=0; i<=200; i+=10)
	{
		pen.SetColor(i+50,0,0);
		pen.DrawLine(0,i, i,200);
	}
}

void TGhostPen::Open(const string &filename)
{
	this->filename = filename;
	fd  = fopen(filename.c_str(),"w");
	
	fprintf(fd,
		"%%!PS-Adobe-2.0\n"
	  "%%%%Creator: TOAD GUI Toolkit, TGhostPen eXperiment\n"
	  "%%%%Title: %s\n"
	  "%%%%EndComments\n",filename.c_str());
}

void TGhostPen::Close()
{
	fprintf(fd,"showpage\n");
	fclose(fd);
}

void TGhostPen::SetColor(short r,short g,short b)
{
	fprintf(fd,"%f %f %f setrgbcolor\n",(double)r/255.0,(double)g/255.0,(double)b/255.0);
}

void TGhostPen::DrawLine(int x1,int y1,int x2,int y2)
{
	fprintf(fd,"%i %i moveto %i %i lineto stroke\n",left+x1,top-y1,left+x2,top-y2);
}

void TGhostPen::DrawRectangle(int x,int y,int w,int h)
{
	fprintf(fd,
		"%i %i moveto "
		"%i 0 rlineto "
		"0 %i rlineto "
		"%i 0 rlineto "
		"closepath "
		"stroke\n",
		left+x,top-y,
 		w,-h,-w);
}

void TGhostPen::FillRectangle(int x,int y,int w,int h)
{
	fprintf(fd,
		"%i %i moveto "
		"%i 0 rlineto "
		"0 %i rlineto "
		"%i 0 rlineto "
		"closepath "
		"fill\n",
		left+x,top-y,
 		w,-h,-w);
}
