/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>

TGGroup::~TGGroup()
{
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	while(p!=e) {
		delete *p;
		p++;
	} 
}

void 
TGGroup::CalcSize()
{
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	if (p==e)
		return;
	TRectangle r;
	(*p)->getShape(r);
	p1.x=r.x;
	p1.y=r.y;
	p2.x=r.x+r.w-1;
	p2.y=r.y+r.h-1;
	p++;
	while(p!=e) {
		(*p)->getShape(r);
		if (r.x < p1.x)
			p1.x = r.x;
		if (r.y < p1.y)
			p1.y = r.y;
		int ix2 = r.x + r.w-1;
		int iy2 = r.y + r.h-1;
		if (p2.x < ix2)
			p2.x=ix2;
		if (p2.y < iy2)
			p2.y=iy2;
		p++;
	}
}

void 
TGGroup::paint(TPen &pen, EPaintType)
{
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	while(p!=e) {
		(*p)->paint(pen, NORMAL);
		p++;
	}
}

bool 
TGGroup::getHandle(unsigned n, TPoint &p)
{
	return false;
}

double
TGGroup::distance(int mx, int my)
{
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	if (p==e)
		return OUT_OF_RANGE;
	double d = (*p)->distance(mx, my);
	p++;
	while(p!=e) {
		double td = (*p)->distance(mx, my);
		if (td<d)
			d=td;
		p++;
	}
	return d;
}

void
TGGroup::translate(int dx, int dy)
{
	p1.x+=dx;
	p1.y+=dy;
	p2.x+=dx;
	p2.y+=dy;
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	while(p!=e) {
		(*p)->translate(dx,dy);
		p++;
	}
}

void TGGroup::store(TOutObjectStream &file, ulong version)
{
	file.WriteDWord(gadgets.size());
	TGadgetStorage::iterator p,e;
	p = gadgets.begin();
	e = gadgets.end();
	while(p!=e) {
		TGadget::Store(file, *p);
		p++;
	} 
}

void TGGroup::restore(TInObjectStream &file, ulong version)
{
	unsigned count = file.ReadDWord();
	for(unsigned i=0; i<count; i++) {
		TGadget *g = TGadget::Restore(file);
		gadgets.push_back(g);
	}
	CalcSize();
}
