/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TGadgetEditor
#define TGadgetEditor TGadgetEditor

class TGadget;
class THScrollBar;
class TVScrollBar;

#include <toad/gadgetwindow.hh>
#include <toad/gadgeteditor/undoable.hh>
#include <toad/util/history.hh>

#include <set>

class TGadgetEditor:
	public TGadgetWindow
{
		typedef TGadgetWindow super;
	public:
		
		TGadgetEditor();
		void SetWindow(TWindow*);

		TGadgetEditor(TWindow*, const string &title);
		~TGadgetEditor();

		void EnableScroll(bool);
		void EnableGrid(bool);
		void SetBackground(int,int,int);

		unsigned result;						// values are defined in TGadget

	protected:
		TWindow *window;						// current window

	public:
		static const unsigned OP_SELECT = 0;
		static const unsigned OP_CREATE = 1;
		void SetOperation(unsigned);
		void SetCreate(TGadget*);

		void SetLineColor(const TRGB&);
		void SetFillColor(const TRGB&);
		void SetFilled(bool);
		
		void Invalidate() { if (window) window->Invalidate(); }
		void InvalidateFigure(TGadget*);

		void Add(TGadget*);		
		void DeleteGadget(TGadget*);

		void SelectAll();

		//. Unselect all selected objects.
		void ClearSelection();
		
		//. Delete Selected Objects
		void DeleteSelection();
		void DeleteAll();
		
		void Selection2Top();
		void Selection2Bottom();
		void SelectionUp();
		void SelectionDown();
		
		void Gadget2Top(TGadget*);
		void Gadget2Bottom(TGadget*);
		void GadgetUp(TGadget*);
		void GadgetDown(TGadget*);

		void Group();
		void Ungroup();
		
		typedef GHistory<PUndoable> THistory;
		THistory history;
		void Undo();
		void Redo();
		void ClearHistory() {history.Clear();}
		
		TGadget* FindGadgetAt(int x, int y);

		static const unsigned STATE_NONE = 0;
		
		// states for OP_SELECT
		static const unsigned STATE_MOVE = 1;						// moving objects
		static const unsigned STATE_MOVE_HANDLE = 2;		// move handle
		static const unsigned STATE_SELECT_RECT = 3;		// select rectangular area
		static const unsigned STATE_EDIT = 4;						// edit object
		
		// states for OP_CREATE
		static const unsigned STATE_START_CREATE = 5;		// set during `startCreate' and first `mouseLDown'
		static const unsigned STATE_CREATE = 6;
		
		unsigned state;
		
		int down_x, down_y;															// last mouseXDown postion

		// undo stuff:
		int memo_x, memo_y;
		unsigned memo_n;
		TPoint memo_pt;

		// triggered after `selection' was modified
		TSignal sigSelectionChanged;

		typedef set<TGadget*> TGadgetSet;
		TGadgetSet selection;

		void paint();
		void resize();
		void mouseLDown(int,int,unsigned);
		void mouseMove(int,int,unsigned);
		void mouseLUp(int,int,unsigned);
		void keyDown(TKey, char*, unsigned);

	protected:
		void Init();
	
		bool filled;
		TRGB line_color;
		TRGB fill_color;
		
		TRGB background_color;
		bool draw_grid;
		
		unsigned operation;
		
		TGadget* gadget;				// the current gadget during create & edit
		TGadget* gtemplate;			// the gadget template during create
		unsigned gridx, gridy;
		
		int handle;							// the current handle or -1 during select
		
		bool use_scrollbars;
		TVScrollBar *vscroll;
		THScrollBar *hscroll;
		int x1,x2, y1,y2;
		bool update_scrollbars;	// checked during paint
		void UpdateScrollbars();
		void actVScroll(int);
		void actHScroll(int);

		void StopOperation();		// stop the current operation
};

#endif
