/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef urlstreambase
#define urlstreambase urlstreambase

#include <iostream>
#include <string>

class urlstreambase:
	public virtual ios
{
	public:
		static void save_memory_file(const string &name, 
																 const char* data, unsigned len);

	protected:
		urlstreambase() {
			fd = -1;
			protocol = NONE;
		}
		~urlstreambase() {
			set_sb(NULL);
		}
		string url;
		enum EProtocol {
			NONE,
			MEMORY,
			FILE,
			HTTP,
			FTP
		} protocol;
		string hostname;
		int port;
		string filename;

		int fd;

		void parse(const string&);
		void iopen();
		void iopen_http();
		void iopen_file();
		void iopen_memory();
		
		void oopen();
		void oopen_file();

		void set_sb(streambuf *new_sb, int new_fd = -1);
};

class iurlstream:
	public urlstreambase, public istream
{
	public:
		iurlstream(const string &url) {
			parse(url);
			iopen();
		}
		iurlstream() {}
		void open(const string &url) {
			parse(url);
			iopen();
		}
};

class ourlstream:
	public urlstreambase, public ostream
{
	public:
		ourlstream(const string &url) {
			parse(url);
			oopen();
		}
		ourlstream(){};
		void open(const string &url) {
			parse(url);
			oopen();
		}
};

// there ain't no such thing as a url stream for input and output

#endif
