/* Generated by wbuild from "Calendar.w"
** (generator version $Revision: 3.0 $ of $Date: 95/08/30 17:50:38 $)
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#line 942 "Calendar.w"
#include <assert.h>
#line 943 "Calendar.w"
#include <ctype.h>
#line 944 "Calendar.w"
#include <stdio.h>
#line 945 "Calendar.w"
#include <string.h>
#line 946 "Calendar.w"
#include <time.h>
#line 948 "Calendar.w"
#include "up.bm"
#line 949 "Calendar.w"
#include "down.bm"
#include <Xfwf/CalendarP.h>
#line 201 "Calendar.w"
static void monthChange(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 229 "Calendar.w"
static void buttonrelease(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 241 "Calendar.w"
static void buttonpress(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);

static XtActionsRec actionsList[] = {
{"monthChange", monthChange},
{"buttonrelease", buttonrelease},
{"buttonpress", buttonpress},
};

static char defaultTranslations[] = "\
<Btn1Down>: buttonpress() \n\
<BtnUp>: buttonrelease() \n\
<Key>Up: monthChange(+12) \n\
<Key>Down: monthChange(-12) \n\
<Key>Right: monthChange(+1) \n\
<Key>Left: monthChange(-1) \n\
";
static void _resolve_inheritance(
#if NeedFunctionPrototypes
WidgetClass
#endif
);
#line 668 "Calendar.w"
static void initialize(
#if NeedFunctionPrototypes
Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 709 "Calendar.w"
static void realize(
#if NeedFunctionPrototypes
Widget,XtValueMask *,XSetWindowAttributes *
#endif
);
#line 720 "Calendar.w"
static void destroy(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 732 "Calendar.w"
static Boolean  set_values(
#if NeedFunctionPrototypes
Widget ,Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 800 "Calendar.w"
static void expose(
#if NeedFunctionPrototypes
Widget,XEvent *,Region 
#endif
);
#line 323 "Calendar.w"
static char * monthname[] = {
			"January",
			"February",
			"March",
			"April",
			"May",
			"June",
			"July",
			"August",
			"September",
			"October",
			"November",
			"December"
			};
#line 338 "Calendar.w"
static char * dayname[] = {"Su","Mo","Tu","We","Th","Fr","Sa"};
#line 340 "Calendar.w"
static int  maximum(
#if NeedFunctionPrototypes
int ,int 
#endif
);
#line 345 "Calendar.w"
static void month_plus(
#if NeedFunctionPrototypes
Widget,int *,int *
#endif
);
#line 356 "Calendar.w"
static void month_minus(
#if NeedFunctionPrototypes
Widget,int *,int *
#endif
);
#line 370 "Calendar.w"
static void timer_callback(
#if NeedFunctionPrototypes
XtPointer ,XtIntervalId *
#endif
);
#line 405 "Calendar.w"
static void make_gcs(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 431 "Calendar.w"
static int  heading_height(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 442 "Calendar.w"
static void compute_size(
#if NeedFunctionPrototypes
Widget,Dimension *,Dimension *
#endif
);
#line 459 "Calendar.w"
static Boolean  leapyear(
#if NeedFunctionPrototypes
int 
#endif
);
#line 467 "Calendar.w"
static void fill_matrix(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 530 "Calendar.w"
static long  day_number(
#if NeedFunctionPrototypes
XfwfDate 
#endif
);
#line 584 "Calendar.w"
static void get_day_position(
#if NeedFunctionPrototypes
Widget,int ,int ,int *,int *
#endif
);
#line 612 "Calendar.w"
static void write_date(
#if NeedFunctionPrototypes
Widget,int ,int ,int 
#endif
);
#line 340 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 340 "Calendar.w"
static int  maximum(int  a,int  b)
#else
#line 340 "Calendar.w"
static int  maximum(a,b)int  a;int  b;
#endif
#line 341 "Calendar.w"
{
	return (a>b) ? a : b;
}
#line 345 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 345 "Calendar.w"
static void month_plus(Widget self,int * mo,int * yr)
#else
#line 345 "Calendar.w"
static void month_plus(self,mo,yr)Widget self;int * mo;int * yr;
#endif
#line 346 "Calendar.w"
{
	*mo=((XfwfCalendarWidget)self)->xfwfCalendar.month;
	*yr=((XfwfCalendarWidget)self)->xfwfCalendar.year;
	(*mo)++;
	while (*mo>12) {
		(*yr)++;
		*mo -= 12;
		}
}
#line 356 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 356 "Calendar.w"
static void month_minus(Widget self,int * mo,int * yr)
#else
#line 356 "Calendar.w"
static void month_minus(self,mo,yr)Widget self;int * mo;int * yr;
#endif
#line 357 "Calendar.w"
{
	*mo=((XfwfCalendarWidget)self)->xfwfCalendar.month;
	*yr=((XfwfCalendarWidget)self)->xfwfCalendar.year;
	(*mo)--;
	while (*mo<1) {
		(*yr)--;
		*mo += 12;
		}
}
#line 370 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 370 "Calendar.w"
static void timer_callback(XtPointer  call_data,XtIntervalId * id)
#else
#line 370 "Calendar.w"
static void timer_callback(call_data,id)XtPointer  call_data;XtIntervalId * id;
#endif
#line 371 "Calendar.w"
{
    Widget self = (Widget) call_data;
	int mo, yr;

	switch (((XfwfCalendarWidget)self)->xfwfCalendar.movement) {
		case MonthPlus:
			month_plus(self, &mo, &yr);
			break;
		case MonthMinus:
			month_minus(self, &mo, &yr);
			break;
		case YearPlus:
			mo=((XfwfCalendarWidget)self)->xfwfCalendar.month;
			yr = ((XfwfCalendarWidget)self)->xfwfCalendar.year+1;
			break;
		case YearMinus:
			mo=((XfwfCalendarWidget)self)->xfwfCalendar.month;
			yr = ((XfwfCalendarWidget)self)->xfwfCalendar.year-1;
			break;
		default:
			printf("Warning: illegal movement in Calendar.w\n");
			break;
		}

	XtVaSetValues(self, XtNmonth, mo, XtNyear, yr, NULL);
	((XfwfCalendarWidget)self)->xfwfCalendar.click_date.month = ((XfwfCalendarWidget)self)->xfwfCalendar.month;
	((XfwfCalendarWidget)self)->xfwfCalendar.click_date.year = ((XfwfCalendarWidget)self)->xfwfCalendar.year;
   	XtCallCallbackList(self, ((XfwfCalendarWidget)self)->xfwfCalendar.changeCallback, (XtPointer) &((XfwfCalendarWidget)self)->xfwfCalendar.click_date);

	/* add a new timer */
    ((XfwfCalendarWidget)self)->xfwfCalendar.timer = XtAppAddTimeOut(XtWidgetToApplicationContext(self),
                             ((XfwfCalendarWidget)self)->xfwfCalendar.repeatDelay, timer_callback, self);
}
#line 405 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 405 "Calendar.w"
static void make_gcs(Widget self)
#else
#line 405 "Calendar.w"
static void make_gcs(self)Widget self;
#endif
#line 406 "Calendar.w"
{
	XtGCMask mask;
	XGCValues values;

	values.foreground=((XfwfCalendarWidget)self)->xfwfCalendar.headingColor;
	values.background=((XfwfCalendarWidget)self)->core.background_pixel;
	values.font=((XfwfCalendarWidget)self)->xfwfCalendar.headingFont->fid;
	mask = GCForeground | GCBackground | GCFont;
	((XfwfCalendarWidget)self)->xfwfCalendar.headingGC=XtGetGC(self, mask, &values);

	values.foreground = ((XfwfCalendarWidget)self)->xfwfCalendar.boxColor;
	((XfwfCalendarWidget)self)->xfwfCalendar.boxGC=XtGetGC(self,mask,&values);

	values.font = ((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->fid;
	values.foreground = ((XfwfCalendarWidget)self)->xfwfCalendar.color1;
	((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC=XtGetGC(self,mask,&values);

	mask |=  GCFunction;
	values.function =  GXxor;
	((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC=XtGetGC(self,mask,&values);
}
#line 431 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 431 "Calendar.w"
static int  heading_height(Widget self)
#else
#line 431 "Calendar.w"
static int  heading_height(self)Widget self;
#endif
#line 432 "Calendar.w"
{
	if (((XfwfCalendarWidget)self)->xfwfCalendar.heading)
		return maximum(up_height,((XfwfCalendarWidget)self)->xfwfCalendar.headingFont->ascent + ((XfwfCalendarWidget)self)->xfwfCalendar.headingFont->descent)
			+ ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset + 1;
	else
		return 0;
}
#line 442 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 442 "Calendar.w"
static void compute_size(Widget self,Dimension * wd,Dimension * ht)
#else
#line 442 "Calendar.w"
static void compute_size(self,wd,ht)Widget self;Dimension * wd;Dimension * ht;
#endif
#line 443 "Calendar.w"
{
	int cw, hw;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;
	
	cw = XTextWidth(((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont,"0",1)*20 + ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset*2;
	hw = XTextWidth(((XfwfCalendarWidget)self)->xfwfCalendar.headingFont,"September 0000", 14) +
			2*up_width + 2*down_width + ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset*4;

/*printf("cw=%d, hw=%d\n", cw, hw);*/
	*wd = cw>hw ? cw : hw;
	*ht = heading_height(self) + ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset*(datelines+2) + 
			(datelines+1)*(((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->ascent + ((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->descent);
}
#line 459 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 459 "Calendar.w"
static Boolean  leapyear(int  year)
#else
#line 459 "Calendar.w"
static Boolean  leapyear(year)int  year;
#endif
#line 460 "Calendar.w"
{
	if ((((year%4)==0) && ((year%100) !=0)) || ((year%400)==0))
		return True;
	else
		return False;
}
#line 467 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 467 "Calendar.w"
static void fill_matrix(Widget self)
#else
#line 467 "Calendar.w"
static void fill_matrix(self)Widget self;
#endif
#line 468 "Calendar.w"
{
	int i, j;
	XfwfDate dt;
	int day;
	int daysinmonth;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;

	dt.day=1;
	dt.month=((XfwfCalendarWidget)self)->xfwfCalendar.month;
	dt.year=((XfwfCalendarWidget)self)->xfwfCalendar.year;

	switch (((XfwfCalendarWidget)self)->xfwfCalendar.month) {
		case 1:
		case 3:
		case 5:
		case 7:
		case 8:
		case 10:
		case 12:
			daysinmonth=31;
			break;
		case 4:
		case 6:
		case 9:
		case 11:
			daysinmonth=30;
			break;
		case 2:
			daysinmonth = leapyear(((XfwfCalendarWidget)self)->xfwfCalendar.year) ? 29 :28;
			break;
		}
	day = 1 - ((day_number(dt)+1) % 7);
	for (i=0; i<6; i++)
		for (j=0; j<7; j++) {
			if ((day>=1) && (day <= daysinmonth))
				((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[i%datelines][j] = day;
			else if (i<datelines)
				((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[i][j] = 0;
			day++;
			}
}
#line 530 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 530 "Calendar.w"
static long  day_number(XfwfDate  dt)
#else
#line 530 "Calendar.w"
static long  day_number(dt)XfwfDate  dt;
#endif
#line 531 "Calendar.w"
{
	long y, a, b, c, e, m;
	long J;


	/* The origin should be chosen to be a century year
	 * that is also a leap year.  We pick 4801 B.C.
	 */
	y = dt.year + 4800;
	if( dt.year < 0 ) {
		y += 1;				/* no year 0 */
		}

	/* The following magic arithmetic calculates a sequence
	 * whose successive terms differ by the correct number of
	 * days per calendar month.  It starts at 122 = March; January
	 * and February come after December.
	 */
	m = dt.month;
	if( m <= 2 ) {
		m += 12;
		y -= 1;
		}
	e = (306 * (m+1))/10;

	a = y/100;	/* number of centuries */
	if( dt.year <= 1582L ) {
		if( dt.year == 1582L ) {
			if( dt.month < 10 )
				goto julius;
			if( dt.month > 10)
				goto gregor;
			if( dt.day >= 15 )
				goto gregor;
			}
julius:				/* Julian Calendar assumed*/
		b = -38;
		}
	else { /* -number of century years that are not leap years */
gregor:
		b = (a/4) - a;
		}

	c = (36525 * y)/100; /* Julian calendar years and leap years */

	/* Add up these terms, plus offset from J 0 to 1 Jan 4801 B.C.
	 * Also fudge for the 122 days from the month algorithm.
	 */
	J = b + c + e + dt.day - 32167;

	return J;
	}
#line 584 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 584 "Calendar.w"
static void get_day_position(Widget self,int  i,int  j,int * x,int * y)
#else
#line 584 "Calendar.w"
static void get_day_position(self,i,j,x,y)Widget self;int  i;int  j;int * x;int * y;
#endif
#line 585 "Calendar.w"
{
	float xinc, xspace, yspace;
	float yinc;
	int ybase, ma, md, digit_width;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;
	Position wx, wy;
	Dimension ww, wh;

	((XfwfCalendarWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &wx, &wy, &ww, &wh);
	ma=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->ascent;
	md=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->descent;
	ybase = heading_height(self) + ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset + ma;
	digit_width = XTextWidth(((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont, "0", 1);
	xspace = ((float) (ww - digit_width*14))/7;
	xinc = xspace + digit_width*2;

	yspace = (((float)(wh-heading_height(self) - ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset -2 -(datelines+1)*(ma+md))))/(datelines+1);
	yinc = yspace+ma+md;
	
	*x = wx + j*xinc + xspace/2;
	*y = wy + ybase + yinc*(i+1) +yspace/2;
	
	/* adjust downwards a bit since digits don't have descenders */
	*y += 2;
/*	printf("wh=%d, wy=%d, ybase=%d, yinc=%f, yspace=%f, y=%d\n", 
		wh, wy, ybase, yinc, yspace, *y);*/
}
#line 612 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 612 "Calendar.w"
static void write_date(Widget self,int  i,int  j,int  ybase)
#else
#line 612 "Calendar.w"
static void write_date(self,i,j,ybase)Widget self;int  i;int  j;int  ybase;
#endif
#line 613 "Calendar.w"
{
	int x, y, x1, y1, x2, y2;
	char buf[5];
	int c;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;
	Position wx, wy;
	Dimension ww, wh;

	((XfwfCalendarWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &wx, &wy, &ww, &wh);

	sprintf(buf, "%2d", ((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[i][j]);
	get_day_position(self,i,j, &x, &y);
	if ((c=((XfwfCalendarWidget)self)->xfwfCalendar.dayColors[ ((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[i][j] ]) ==0)
		c = ((XfwfCalendarWidget)self)->xfwfCalendar.dayColors[0];

	switch(c & ~XfwfReverseDate) {
		case 2: XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color2);
				XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color2^((XfwfCalendarWidget)self)->core.background_pixel);
				break;
		case 3: XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color3);
				XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color3^((XfwfCalendarWidget)self)->core.background_pixel);
				break;
		case 4: XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color4);
				XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color4^((XfwfCalendarWidget)self)->core.background_pixel);
				break;
		case 5: XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color5);
				XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color5^((XfwfCalendarWidget)self)->core.background_pixel);
				break;
		default:XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color1);
				XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.color1^((XfwfCalendarWidget)self)->core.background_pixel);
				break;
        }

	/* compute the box */
	x1 = (ww-1)*j/7;
	y1 = ((wh-1 - ybase)*i)/datelines + ybase;
	x2 = (ww-1)*(j+1)/7;
	y2 = ((wh-1 - ybase)*(i+1))/datelines + ybase;


	XClearArea(XtDisplay(self), XtWindow(self), wx+x1+1, wy+y1+1, x2-x1-1, y2-y1-1, False);

	XDrawString(XtDisplay(self),XtWindow(self),((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC,
		x, y, buf, strlen(buf));
	if (c&XfwfReverseDate) {
		/* invert the box */
		XFillRectangle(XtDisplay(self),XtWindow(self),((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC,
			wx+x1+1,wy+y1+1,x2-x1-1, y2-y1-1);
		}
}

static XtResource resources[] = {
#line 26 "Calendar.w"
{XtNcalendarFont,XtCCalendarFont,XtRFontStruct,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.calendarFont),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.calendarFont),XtRString,(XtPointer)XtDefaultFont },
#line 30 "Calendar.w"
{XtNheadingFont,XtCHeadingFont,XtRFontStruct,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.headingFont),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.headingFont),XtRString,(XtPointer)XtDefaultFont },
#line 35 "Calendar.w"
{XtNcolor1,XtCColor1,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.color1),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.color1),XtRString,(XtPointer)XtDefaultForeground },
#line 36 "Calendar.w"
{XtNcolor2,XtCColor2,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.color2),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.color2),XtRString,(XtPointer)XtDefaultForeground },
#line 37 "Calendar.w"
{XtNcolor3,XtCColor3,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.color3),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.color3),XtRString,(XtPointer)XtDefaultForeground },
#line 38 "Calendar.w"
{XtNcolor4,XtCColor4,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.color4),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.color4),XtRString,(XtPointer)XtDefaultForeground },
#line 39 "Calendar.w"
{XtNcolor5,XtCColor5,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.color5),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.color5),XtRString,(XtPointer)XtDefaultForeground },
#line 43 "Calendar.w"
{XtNheadingColor,XtCHeadingColor,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.headingColor),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.headingColor),XtRString,(XtPointer)XtDefaultForeground },
#line 47 "Calendar.w"
{XtNboxColor,XtCBoxColor,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.boxColor),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.boxColor),XtRString,(XtPointer)XtDefaultForeground },
#line 51 "Calendar.w"
{XtNweekdayColor,XtCWeekdayColor,XtRPixel,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.weekdayColor),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.weekdayColor),XtRString,(XtPointer)XtDefaultForeground },
#line 65 "Calendar.w"
{XtNdayColors,XtCDayColors,XtRInt,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.dayColors),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.dayColors),XtRImmediate,(XtPointer)NULL },
#line 72 "Calendar.w"
{XtNinternalOffset,XtCInternalOffset,XtRDimension,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.internalOffset),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.internalOffset),XtRImmediate,(XtPointer)2 },
#line 76 "Calendar.w"
{XtNmonth,XtCMonth,XtRInt,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.month),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.month),XtRImmediate,(XtPointer)0 },
#line 80 "Calendar.w"
{XtNyear,XtCYear,XtRInt,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.year),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.year),XtRImmediate,(XtPointer)0 },
#line 85 "Calendar.w"
{XtNboxed,XtCBoxed,XtRBoolean,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.boxed),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.boxed),XtRImmediate,(XtPointer)False },
#line 93 "Calendar.w"
{XtNwrapped,XtCWrapped,XtRBoolean,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.wrapped),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.wrapped),XtRImmediate,(XtPointer)False },
#line 101 "Calendar.w"
{XtNheading,XtCHeading,XtRBoolean,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.heading),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.heading),XtRImmediate,(XtPointer)True },
#line 107 "Calendar.w"
{XtNdateCallback,XtCDateCallback,XtRCallback,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.dateCallback),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.dateCallback),XtRImmediate,(XtPointer)NULL },
#line 117 "Calendar.w"
{XtNchangeCallback,XtCChangeCallback,XtRCallback,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.changeCallback),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.changeCallback),XtRImmediate,(XtPointer)NULL },
#line 123 "Calendar.w"
{XtNinitialDelay,XtCInitialDelay,XtRInt,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.initialDelay),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.initialDelay),XtRImmediate,(XtPointer)500 },
#line 124 "Calendar.w"
{XtNrepeatDelay,XtCRepeatDelay,XtRInt,sizeof(((XfwfCalendarRec*)NULL)->xfwfCalendar.repeatDelay),XtOffsetOf(XfwfCalendarRec,xfwfCalendar.repeatDelay),XtRImmediate,(XtPointer)150 },
};

XfwfCalendarClassRec xfwfCalendarClassRec = {
{ /* core_class part */
/* superclass   	*/  (WidgetClass) &xfwfBoardClassRec,
/* class_name   	*/  "XfwfCalendar",
/* widget_size  	*/  sizeof(XfwfCalendarRec),
/* class_initialize 	*/  NULL,
/* class_part_initialize*/  _resolve_inheritance,
/* class_inited 	*/  FALSE,
/* initialize   	*/  initialize,
/* initialize_hook 	*/  NULL,
/* realize      	*/  realize,
/* actions      	*/  actionsList,
/* num_actions  	*/  3,
/* resources    	*/  resources,
/* num_resources 	*/  21,
/* xrm_class    	*/  NULLQUARK,
/* compres_motion 	*/  True ,
/* compress_exposure 	*/  XtExposeCompressMultiple |XtExposeGraphicsExposeMerged ,
/* compress_enterleave 	*/  True ,
/* visible_interest 	*/  TRUE ,
/* destroy      	*/  destroy,
/* resize       	*/  XtInheritResize,
/* expose       	*/  expose,
/* set_values   	*/  set_values,
/* set_values_hook 	*/  NULL,
/* set_values_almost 	*/  XtInheritSetValuesAlmost,
/* get_values+hook 	*/  NULL,
/* accept_focus 	*/  XtInheritAcceptFocus,
/* version      	*/  XtVersion,
/* callback_private 	*/  NULL,
/* tm_table      	*/  defaultTranslations,
/* query_geometry 	*/  XtInheritQueryGeometry,
/* display_acceleator 	*/  XtInheritDisplayAccelerator,
/* extension    	*/  NULL 
},
{ /* composite_class part */
XtInheritGeometryManager,
XtInheritChangeManaged,
XtInheritInsertChild,
XtInheritDeleteChild,
NULL
},
{ /* XfwfCommon_class part */
XtInherit_compute_inside,
XtInherit_total_frame_width,
XtInherit_highlight_border,
XtInherit_unhighlight_border,
XtInherit_would_accept_focus,
XtInherit_traverse,
XtInherit_lighter_color,
XtInherit_darker_color,
/* traversal_trans */  NULL ,
},
{ /* XfwfFrame_class part */
 /* dummy */  0
},
{ /* XfwfBoard_class part */
XtInherit_set_abs_location,
},
{ /* XfwfCalendar_class part */
 /* dummy */  0
},
};
WidgetClass xfwfCalendarWidgetClass = (WidgetClass) &xfwfCalendarClassRec;
/*ARGSUSED*/
#line 201 "Calendar.w"
static void monthChange(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{	int n;
	int mo, yr;

	if (*num_params == 0 || sscanf(params[0], "%d", &n) != 1)
        n = 0;

	mo=((XfwfCalendarWidget)self)->xfwfCalendar.month+n;
	yr=((XfwfCalendarWidget)self)->xfwfCalendar.year;

	while (mo<1) {
		yr--;
		mo += 12;
		}
	while (mo>12) {
		yr++;
		mo -= 12;
		}
	XtVaSetValues(self, XtNmonth, mo, XtNyear, yr, NULL);
	((XfwfCalendarWidget)self)->xfwfCalendar.click_date.month = ((XfwfCalendarWidget)self)->xfwfCalendar.month;
	((XfwfCalendarWidget)self)->xfwfCalendar.click_date.year = ((XfwfCalendarWidget)self)->xfwfCalendar.year;
    XtCallCallbackList(self, ((XfwfCalendarWidget)self)->xfwfCalendar.changeCallback, (XtPointer) &((XfwfCalendarWidget)self)->xfwfCalendar.click_date);
}

/*ARGSUSED*/
#line 229 "Calendar.w"
static void buttonrelease(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    if (((XfwfCalendarWidget)self)->xfwfCalendar.timer_on) {
        ((XfwfCalendarWidget)self)->xfwfCalendar.timer_on = False;
        XtRemoveTimeOut(((XfwfCalendarWidget)self)->xfwfCalendar.timer);
		}
}

/*ARGSUSED*/
#line 241 "Calendar.w"
static void buttonpress(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    int mx, my, i;
	int mo, yr;
	float f, yspace, yinc;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;
    int ybase, ma, md, x, y;
	Position wx, wy;
	Dimension ww, wh;

	((XfwfCalendarWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &wx, &wy, &ww, &wh);

	mo=((XfwfCalendarWidget)self)->xfwfCalendar.month;
	yr=((XfwfCalendarWidget)self)->xfwfCalendar.year;
    mx=event->xbutton.x;
    my=event->xbutton.y;
	i=((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset;    

	if ((((XfwfCalendarWidget)self)->xfwfCalendar.heading) && ((my-wy) < i+up_height)) {
		if ((mx-wx)<i+up_width) {
			((XfwfCalendarWidget)self)->xfwfCalendar.movement=MonthPlus;
			month_plus(self, &mo, &yr);
			}
		else if (((mx-wx)>i+up_width) && ((mx-wx)<2*i+up_width+down_width)) {
			((XfwfCalendarWidget)self)->xfwfCalendar.movement=MonthMinus;
			month_minus(self, &mo, &yr);
			}
		else if ((mx>((XfwfCalendarWidget)self)->core.width-wx-2*i-up_width-down_width) && (mx<((XfwfCalendarWidget)self)->core.width-wx-i-down_width)) {
			yr++;
			((XfwfCalendarWidget)self)->xfwfCalendar.movement=YearPlus;
			}
		else if (mx>((XfwfCalendarWidget)self)->core.width-wx-i-down_width) {
			yr--;
			((XfwfCalendarWidget)self)->xfwfCalendar.movement=YearMinus;
			}
		
		if ((mo!=((XfwfCalendarWidget)self)->xfwfCalendar.month) || (yr!=((XfwfCalendarWidget)self)->xfwfCalendar.year)) {
			XtVaSetValues(self, XtNmonth, mo, XtNyear, yr, NULL);
			((XfwfCalendarWidget)self)->xfwfCalendar.click_date.month = ((XfwfCalendarWidget)self)->xfwfCalendar.month;
			((XfwfCalendarWidget)self)->xfwfCalendar.click_date.year = ((XfwfCalendarWidget)self)->xfwfCalendar.year;
	    	XtCallCallbackList(self, ((XfwfCalendarWidget)self)->xfwfCalendar.changeCallback, (XtPointer) &((XfwfCalendarWidget)self)->xfwfCalendar.click_date);
        	((XfwfCalendarWidget)self)->xfwfCalendar.timer_on = True;
	        ((XfwfCalendarWidget)self)->xfwfCalendar.timer = XtAppAddTimeOut(XtWidgetToApplicationContext(self),
                                 ((XfwfCalendarWidget)self)->xfwfCalendar.initialDelay, timer_callback, self);
			}
		return;
		}

    ma=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->ascent;
    md=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->descent;

	/* the following equations are derived from the grid drawing
		equations in the expose method */
	yspace = (((float)(wh-heading_height(self) - ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset -2 -(datelines+1)*(ma+md))))/(datelines+1);
	yinc = yspace+ma+md;
	ybase = heading_height(self)+((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset+yinc;
	f = ((float) (my-wy-ybase)*datelines)/ (wh-1- ybase);
	y = (f>0) ? f : -1;

	f = (((float) mx-wx)*7)/(ww-1);
	x = (f>0) ? f : -1;

	/* printf("(%d,%d)\n", x,y); */

	if ((x<0) || (x>6) || (y<0) || (y>5))
		return;

	if (((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[y][x] != 0) {
		((XfwfCalendarWidget)self)->xfwfCalendar.click_date.day = ((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[y][x];
		((XfwfCalendarWidget)self)->xfwfCalendar.click_date.month = ((XfwfCalendarWidget)self)->xfwfCalendar.month;
		((XfwfCalendarWidget)self)->xfwfCalendar.click_date.year = ((XfwfCalendarWidget)self)->xfwfCalendar.year;
	    XtCallCallbackList(self, ((XfwfCalendarWidget)self)->xfwfCalendar.dateCallback, (XtPointer) &((XfwfCalendarWidget)self)->xfwfCalendar.click_date);
		}
	}

static void _resolve_inheritance(class)
WidgetClass class;
{
  XfwfCalendarWidgetClass c = (XfwfCalendarWidgetClass) class;
  XfwfCalendarWidgetClass super;
  static CompositeClassExtensionRec extension_rec = {
    NULL, NULLQUARK, XtCompositeExtensionVersion,
    sizeof(CompositeClassExtensionRec), True};
  CompositeClassExtensionRec *ext;
  ext = (XtPointer)XtMalloc(sizeof(*ext));
  *ext = extension_rec;
  ext->next_extension = c->composite_class.extension;
  c->composite_class.extension = ext;
  if (class == xfwfCalendarWidgetClass) return;
  super = (XfwfCalendarWidgetClass)class->core_class.superclass;
}
#line 668 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 668 "Calendar.w"
static void initialize(Widget  request,Widget self,ArgList  args,Cardinal * num_args)
#else
#line 668 "Calendar.w"
static void initialize(request,self,args,num_args)Widget  request;Widget self;ArgList  args;Cardinal * num_args;
#endif
#line 669 "Calendar.w"
{
    time_t ti;
    struct tm *clock;
	int i;
	Position wx, wy;
	Dimension ww, wh;
	int *ip;

	((XfwfCalendarWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &wx, &wy, &ww, &wh);

	/* get the current month */
	if ((((XfwfCalendarWidget)self)->xfwfCalendar.month==0) || (((XfwfCalendarWidget)self)->xfwfCalendar.year==0)) {
	    ti=time(NULL);
    	clock=localtime(&ti);
		((XfwfCalendarWidget)self)->xfwfCalendar.month = clock->tm_mon+1;
		((XfwfCalendarWidget)self)->xfwfCalendar.year = clock->tm_year+1900;
		fill_matrix(self);
		}
	if ((ww==0) || (wh==0)) {
		compute_size(self, &ww, &wh);
		((XfwfCalendarWidget)self)->core.width = ww + 2*wx;
		((XfwfCalendarWidget)self)->core.height = wh + 2*wy;
		}
	((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC=NULL;
	((XfwfCalendarWidget)self)->xfwfCalendar.headingGC=NULL;
	((XfwfCalendarWidget)self)->xfwfCalendar.boxGC=NULL;
	make_gcs(self);
	((XfwfCalendarWidget)self)->xfwfCalendar.timer_on=False;
	ip = (int*) XtMalloc(32*sizeof(int));
	if (((XfwfCalendarWidget)self)->xfwfCalendar.dayColors==NULL) {
		ip[0]=1;
		for (i=1; i<32; i++)
			ip[i] = 0;
		}
	else
		for (i=0; i<32; i++)
			ip[i] = ((XfwfCalendarWidget)self)->xfwfCalendar.dayColors[i];
	((XfwfCalendarWidget)self)->xfwfCalendar.dayColors = ip;
}
#line 709 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 709 "Calendar.w"
static void realize(Widget self,XtValueMask * mask,XSetWindowAttributes * attributes)
#else
#line 709 "Calendar.w"
static void realize(self,mask,attributes)Widget self;XtValueMask * mask;XSetWindowAttributes * attributes;
#endif
#line 710 "Calendar.w"
{

    xfwfBoardClassRec.core_class.realize(self, mask, attributes);
    ((XfwfCalendarWidget)self)->xfwfCalendar.upBitmap = XCreateBitmapFromData(XtDisplay(self), XtWindow(self),
        up_bits, up_width, up_height);
    ((XfwfCalendarWidget)self)->xfwfCalendar.downBitmap = XCreateBitmapFromData(XtDisplay(self), XtWindow(self),
        down_bits, down_width, down_height);
}
#line 720 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 720 "Calendar.w"
static void destroy(Widget self)
#else
#line 720 "Calendar.w"
static void destroy(self)Widget self;
#endif
#line 721 "Calendar.w"
{
	XtReleaseGC(self, ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC);
	XtReleaseGC(self, ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC);
	XtReleaseGC(self, ((XfwfCalendarWidget)self)->xfwfCalendar.boxGC);
	XtReleaseGC(self, ((XfwfCalendarWidget)self)->xfwfCalendar.reversingGC);
	XtFree((char*)((XfwfCalendarWidget)self)->xfwfCalendar.dayColors);
}
#line 732 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 732 "Calendar.w"
static Boolean  set_values(Widget  old,Widget  request,Widget self,ArgList  args,Cardinal * num_args)
#else
#line 732 "Calendar.w"
static Boolean  set_values(old,request,self,args,num_args)Widget  old;Widget  request;Widget self;ArgList  args;Cardinal * num_args;
#endif
#line 733 "Calendar.w"
{
	Boolean need_redisplay = False;
	int i;


	if ((((XfwfCalendarWidget)old)->xfwfCalendar.internalOffset != ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.boxed != ((XfwfCalendarWidget)self)->xfwfCalendar.boxed) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.heading != ((XfwfCalendarWidget)self)->xfwfCalendar.heading))
			need_redisplay = True;

	if (((XfwfCalendarWidget)old)->xfwfCalendar.headingFont != ((XfwfCalendarWidget)self)->xfwfCalendar.headingFont) {
		XSetFont(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.headingFont->fid);
		need_redisplay = True;
		}

	if (((XfwfCalendarWidget)old)->xfwfCalendar.calendarFont != ((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont) {
		XSetFont(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->fid);
		need_redisplay = True;
		}

	if ((((XfwfCalendarWidget)old)->xfwfCalendar.month != ((XfwfCalendarWidget)self)->xfwfCalendar.month) || 
		(((XfwfCalendarWidget)old)->xfwfCalendar.wrapped != ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.year != ((XfwfCalendarWidget)self)->xfwfCalendar.year)) {
			fill_matrix(self);
			need_redisplay = True;
			}

	if (((XfwfCalendarWidget)old)->xfwfCalendar.dayColors != ((XfwfCalendarWidget)self)->xfwfCalendar.dayColors) { 
			for (i=0; i<32; i++)
				((XfwfCalendarWidget)old)->xfwfCalendar.dayColors[i] = ((XfwfCalendarWidget)self)->xfwfCalendar.dayColors[i];
			((XfwfCalendarWidget)self)->xfwfCalendar.dayColors = ((XfwfCalendarWidget)old)->xfwfCalendar.dayColors;
			need_redisplay = True;
			}

	if (((XfwfCalendarWidget)old)->xfwfCalendar.headingColor != ((XfwfCalendarWidget)self)->xfwfCalendar.headingColor) {
		XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, ((XfwfCalendarWidget)self)->xfwfCalendar.headingColor);
		need_redisplay=True;
		}

	if (((XfwfCalendarWidget)old)->xfwfCalendar.boxColor != ((XfwfCalendarWidget)self)->xfwfCalendar.boxColor) {
		XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.boxGC, ((XfwfCalendarWidget)self)->xfwfCalendar.boxColor);
		need_redisplay=True;
		}

	if ((((XfwfCalendarWidget)old)->xfwfCalendar.color1 != ((XfwfCalendarWidget)self)->xfwfCalendar.color1) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.color2 != ((XfwfCalendarWidget)self)->xfwfCalendar.color2) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.color3 != ((XfwfCalendarWidget)self)->xfwfCalendar.color3) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.color4 != ((XfwfCalendarWidget)self)->xfwfCalendar.color4) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.color5 != ((XfwfCalendarWidget)self)->xfwfCalendar.color5) ||
		(((XfwfCalendarWidget)old)->xfwfCalendar.weekdayColor != ((XfwfCalendarWidget)self)->xfwfCalendar.weekdayColor)) 
			need_redisplay=True;
		
/*	if (need_redisplay) {
		compute_size($, &($width), &($height));
		}
*/
	return need_redisplay;
}
#line 800 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 800 "Calendar.w"
static void expose(Widget self,XEvent * event,Region  region)
#else
#line 800 "Calendar.w"
static void expose(self,event,region)Widget self;XEvent * event;Region  region;
#endif
#line 801 "Calendar.w"
{
	int x, y, a, d;
	char buf[30];
	int ybase, ma, md, i, j;
	Position wx, wy;
	Dimension ww, wh;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;
	float yspace, yinc;
		
	if(! XtIsRealized(self))
		return ;

	if(event == NULL)
	{
		XClearWindow(XtDisplay(self),XtWindow(self));
		return;
	}

	xfwfBoardClassRec.core_class.expose(self,event,region);
	((XfwfCalendarWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &wx, &wy, &ww, &wh);

	/* draw the heading */

	if (((XfwfCalendarWidget)self)->xfwfCalendar.heading) {
		/* draw the up/down buttons */
		x=wx;
		y=wy;
		XCopyPlane(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.upBitmap, XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, 0, 0, 
			up_width, up_height, x, y, 1);
		x += ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset + up_width;
		XCopyPlane(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.downBitmap, XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, 0, 0, 
			down_width, down_height, x, y, 1);
		x = wx+ww - ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset - up_width - down_width;
		XCopyPlane(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.upBitmap, XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, 0, 0, 
			up_width, up_height, x, y, 1);
		x += ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset + up_width;
		XCopyPlane(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.downBitmap, XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, 0, 0, 
			down_width, down_height, x, y, 1);

		/* draw the month and year */
		sprintf(buf, "%s %4d", monthname[((XfwfCalendarWidget)self)->xfwfCalendar.month-1], ((XfwfCalendarWidget)self)->xfwfCalendar.year);
		x = (((XfwfCalendarWidget)self)->core.width - XTextWidth(((XfwfCalendarWidget)self)->xfwfCalendar.headingFont,buf,strlen(buf)))/2;
		a = ((XfwfCalendarWidget)self)->xfwfCalendar.headingFont->ascent;
		d = ((XfwfCalendarWidget)self)->xfwfCalendar.headingFont->descent;
		if (up_height-a-d > 0) 
			y =(up_height-d-a)/2 + a;
		else
			y = a;
		XDrawString(XtDisplay(self),XtWindow(self),((XfwfCalendarWidget)self)->xfwfCalendar.headingGC,
			x, y+wy, buf, strlen(buf));

		/* draw the heading underline */
		y = maximum(up_height, a+d) + ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset + wx;
		XDrawLine(XtDisplay(self), XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.headingGC, wx, y,
			wx+ww-1, y);
		}


	/* draw the calendar */

	ma=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->ascent;
	md=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->descent;

	ybase = heading_height(self) + ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset + ma;

	/* print the weekday headings */
	XSetForeground(XtDisplay(self), ((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC, ((XfwfCalendarWidget)self)->xfwfCalendar.weekdayColor);
	for (j=0; j<7; j++) {
		get_day_position(self,-1,j, &x, &y);
		XDrawString(XtDisplay(self),XtWindow(self),((XfwfCalendarWidget)self)->xfwfCalendar.calendarGC,
					x, y, dayname[j], strlen(dayname[j]));
				}

	/* print the day numbers */
	yspace = (((float)(wh-heading_height(self) - ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset -2 -(datelines+1)*(ma+md))))/(datelines+1);
	yinc = yspace+ma+md;
	ybase = heading_height(self)+((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset+yinc;
	for (i=0; i<datelines; i++)
		for (j=0; j<7; j++) 
			if (((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[i][j]>0) 
				write_date(self, i, j, ybase);

	/* draw the grid if needed */
	if (((XfwfCalendarWidget)self)->xfwfCalendar.boxed) {
		/* draw vertical lines */
		for (i=0; i<8; i++) {
			x = (ww-1)*i/7;
			XDrawLine(XtDisplay(self), XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.boxGC, 
				wx+x, wy+ybase,
				wx+x, wy+wh-1);
			}

		/* draw horizontal lines */
		for (i=0; i<=datelines; i++) {
			y = ((wh-1 - ybase)*i)/datelines + ybase;
			XDrawLine(XtDisplay(self), XtWindow(self), ((XfwfCalendarWidget)self)->xfwfCalendar.boxGC, 
				wx, wy+y,
				wx+ww-1, wy+y);
			}
		}
	}
#line 179 "Calendar.w"
#line 185 "Calendar.w"
#line 912 "Calendar.w"
/*ARGSUSED*/
#if NeedFunctionPrototypes
#line 912 "Calendar.w"
void XfwfSetDayColors(Widget self,int  colors[])
#else
#line 912 "Calendar.w"
void XfwfSetDayColors(self,colors)Widget self;int  colors[];
#endif
#line 913 "Calendar.w"
{
	int i, j, day;
	float yspace, yinc;
	int ybase;
	int datelines = ((XfwfCalendarWidget)self)->xfwfCalendar.wrapped ? 5 : 6;
	Position wx, wy;
	Dimension ww, wh;
	int ma, md;

	((XfwfCalendarWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &wx, &wy, &ww, &wh);

	ma=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->ascent;
	md=((XfwfCalendarWidget)self)->xfwfCalendar.calendarFont->descent;
	yspace = (((float)(wh-heading_height(self) - ((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset -2 -(datelines+1)*(ma+md))))/(datelines+1);
	yinc = yspace+ma+md;
	ybase = heading_height(self)+((XfwfCalendarWidget)self)->xfwfCalendar.internalOffset+yinc;

	/* print the day numbers */
	for (i=0; i<datelines; i++)
		for (j=0; j<7; j++) {
			day=((XfwfCalendarWidget)self)->xfwfCalendar.calmatrix[i][j];
			if ((day>0) && (colors[day] != ((XfwfCalendarWidget)self)->xfwfCalendar.dayColors[day])) {
				((XfwfCalendarWidget)self)->xfwfCalendar.dayColors[day] = colors[day];
				write_date(self, i, j, ybase);
				}
			}		
	}
