'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfSimpleSGML
.SH DESCRIPTION
The SimpleSGML widget accepts text and parses it, using a
simplified SGML syntax. The resulting tokens are combined with
information from a style sheet and transformed into `chunks', which
are rendered (by the superclass).





.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfSimpleSGML
Name	Class	Type	Default
XtNstyle	XtCStyle	String 	NULL 
XtNtitle	XtCTitle	String 	NULL 

.TE
.ps +2


.TP
.I "XtNstyle"
The \fIstyle\fP resource contains a stylesheet. Stylesheet syntax is the
same as resource database syntax, except that the components of a
resource are not widgets, but SGML elements. The string pointed to by
\fIstyle\fP is not copied to private storage.

	




.TP
.I "XtNtitle"
The document title. This resource is set by the widget itself, when
it parses SGML text that, according to the style sheet, belongs in the
title.

	



.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFormattedText
Name	Class	Type	Default
XtNfontFamily1	XtCFontFamily1	String 	"times"
XtNfontCharset1	XtCFontCharset1	String 	"iso8859-1"
XtNfontSlant1	XtCFontSlant1	String 	"i"
XtNfontBold1	XtCFontBold1	String 	"bold"
XtNfontSizes1	XtCFontSizes1	String 	"72 80 100 120 140 180 240"
XtNfontFamily2	XtCFontFamily2	String 	"helvetica"
XtNfontCharset2	XtCFontCharset2	String 	"iso8859-1"
XtNfontSlant2	XtCFontSlant2	String 	"o"
XtNfontBold2	XtCFontBold2	String 	"bold"
XtNfontSizes2	XtCFontSizes2	String 	"72 80 100 120 140 180 240"
XtNfontFamily3	XtCFontFamily3	String 	"courier"
XtNfontCharset3	XtCFontCharset3	String 	"iso8859-1"
XtNfontSlant3	XtCFontSlant3	String 	"o"
XtNfontBold3	XtCFontBold3	String 	"bold"
XtNfontSizes3	XtCFontSizes3	String 	"72 80 100 120 140 180 240"
XtNfontFamily4	XtCFontFamily4	String 	"wwwicons"
XtNfontCharset4	XtCFontCharset4	String 	"*"
XtNfontSlant4	XtCFontSlant4	String 	"*"
XtNfontBold4	XtCFontBold4	String 	"*"
XtNfontSizes4	XtCFontSizes4	String 	"72 80 100 120 140 180 240"
XtNfontFamily5	XtCFontFamily5	String 	"symbol"
XtNfontCharset5	XtCFontCharset5	String 	"*"
XtNfontSlant5	XtCFontSlant5	String 	"*"
XtNfontBold5	XtCFontBold5	String 	"*"
XtNfontSizes5	XtCFontSizes5	String 	"72 80 100 120 140 180 240"
XtNactivate	XtCActivate	Callback	NULL 
XtNenter	XtCEnter	Callback	NULL 
XtNleave	XtCLeave	Callback	NULL 
XtNactiveCursor	XtCActiveCursor	Cursor 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XmManager
Name	Class	Type	Default
XtNbottom_shadow_color	XtCBottom_shadow_color	Pixel 	0 
XtNbottom_shadow_pixmap	XtCBottom_shadow_pixmap	Pixmap 	0 
XtNforeground	XtCForeground	Pixel 	0 
XtNhelp_callback	XtCHelp_callback	Callback	NULL 
XtNhighlight_color	XtCHighlight_color	Pixel 	0 
XtNhighlight_pixmap	XtCHighlight_pixmap	Pixmap 	None 
XtNinitial_focus	XtCInitial_focus	Widget 	NULL 
navigationType	XtCNavigationType	NavigationType	XmTAB_GROUP 
XtNshadow_thickness	XtCShadow_thickness	Dimension 	0 
XtNstring_direction	XtCString_direction	XMStringDirection 	0 
XtNtop_shadow_color	XtCTop_shadow_color	Pixel 	0 
XtNtop_shadow_pixmap	XtCTop_shadow_pixmap	Pixmap 	None 
XtNtraversal_on	XtCTraversal_on	Boolean 	True 
XtNunit_type	XtCUnit_type	Unsigned  char 	XmPIXELS 
XtNuser_data	XtCUser_data	XTPointer 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

The \fIXfwfSSGMLData\fP struct is passed in the \fIdata\fP field of the
\fIXfwfFTextCallbackStruct\fP that is passed as \fIcall_data\fP argument in
the \fIactivate\fP callback. It contains a URL and a flag to indicate if
the URL is of type `ismap'.

	


.nf

.B type
 XfwfSSGMLData = struct {
            String url;
            Bool ismap;
        }
.fi


The \fIXfwfAddText\fP function is a convenience function that calls the
\fIadd_text\fP method of the widget. The text is parsed and rendered in
the widget. \fIXfwfAddText\fP may be called several times, each time
adding some text at the end. Because of this, the last part of the
text may not be displayed until the parser can recognize a complete
token. To signal the end of the data, call \fIXfwfAddText\fP with \fInchars
= 0\fP.




.nf
XfwfAddText( $, const  char * text, Cardinal  nchars)
.fi


.SS "Translations"

The same translations as in the superclass.




.nf
<Btn1Down>,<Btn1Up>: activate() 
.fi



.nf
<Motion>: motion() 
.fi

