'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfSlider2
.SH DESCRIPTION
A Slider2 widget consists of a rectangular area in which a `thumb' can be
moved about. A Slider2 is typically used to pan or scroll another window; as
such is can replace two scrollbars. The thumb can be dragged with the mouse,
or the mouse can be clicked next to the thumb, to move it in the direction of
the mouse. The thumb may contain one or more lines of text, although there
is usually no room for more than one or two words.

The widget has three callbacks. The thumb position and size are not
controled by resources, but by calling a function.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfSlider2
Name	Class	Type	Default
XtNthumbColor	XtCThumbColor	Color 	XtDefaultBackground 
XtNthumbPixmap	XtCThumbPixmap	Pixmap 	NULL 
XtNminsize	XtCMinsize	Dimension 	20 
XtNthumbFrameWidth	XtCThumbFrameWidth	Dimension 	2 
XtNthumbFrameType	XtCThumbFrameType	FrameType 	XfwfRaised 
XtNscrollCallback	XtCScrollCallback	Callback	NULL 
XtNscrollResponse	XtCScrollResponse	XtCallbackProc 	scroll_response 

.TE
.ps +2

.TP
.I "XtNthumbColor"
The color of the thumb is by default set to the default background
color of the display, but it can be changed with the \fIthumbColor\fP
resource. It is also possible to tile the thumb with a pixmap, see
below.

	

.TP
.I "XtNthumbPixmap"
Instead of a color, the thumb can also be tiled with a pixmap.
However, there is currently no converter from string to pixmap, so
this resource can only be set from the application, not from resource
files.

If both \fIthumbColor\fP and \fIthumbPixmap\fP are set, the pixmap takes
precedence.

	

.TP
.I "XtNminsize"
The minimum size of the thumb is by default 20 pixels. It can be set
with the \fIminsize\fP resource.

	

.TP
.I "XtNthumbFrameWidth"
The width of the frame around the thumb is independent of the frame
around the whole widget. It can be set with \fIthumbFrameWidth\fP.

	

.TP
.I "XtNthumbFrameType"
The style of the frame around the thumb is set with
\fIthumbFrameType\fP. By default, it is \fIXfwfRaised\fP. Note that there are no
resources to control the shadow scheme of the thumb independently from
that of the outer frame. That means that the resources \fIshadowScheme\fP,
\fItopShadowColor\fP, \fItopShadowStipple\fP, etc, also influence the frame of the
thumb.

	

.TP
.I "XtNscrollCallback"
The routines on the callback list are called whenever the user
manipulates the slider and also when the Slider2 receives a call on
its \fIscrollResponse\fP function with a reason other than \fIXfwfSNotify\fP.

The \fIcall_data\fP parameter of the callback routines is a pointer
to an \fIXfwfScrollInfo\fP structure, which looks like this: \fItypedef
struct _XfwfScrollInfo { XfwfSReason reason; XfwfSFlags flags; float
vpos, vsize, hpos, hsize;} XfwfScrollInfo\fP.

	

.TP
.I "XtNscrollResponse"
The Slider2 widget provides has a method for dealing with scroll
requests from the application or from other widgets. A pointer to that
function can be retrieved with \fIXtGetValues\fP as the resource
\fIXtNscrollResponse\fP. This resource can only be queried, not set.

	

.TP
.I "XtNframeWidth"
The default frame width is changed from 0 to 2.

	

.TP
.I "XtNframeType"
The default frame type is now \fIXfwfSunken\fP.

	

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfLabel
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNtablist	XtCTablist	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Color 	XtDefaultForeground 
XtNhlForeground	XtCHlForeground	Color 	XtDefaultForeground 
XtNalignment	XtCAlignment	Alignment 	0 
XtNtopMargin	XtCTopMargin	Dimension 	2 
XtNbottomMargin	XtCBottomMargin	Dimension 	2 
XtNleftMargin	XtCLeftMargin	Dimension 	2 
XtNrightMargin	XtCRightMargin	Dimension 	2 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 
XtNrvStart	XtCRvStart	Int 	0 
XtNrvLength	XtCRvLength	Int 	0 
XtNhlStart	XtCHlStart	Int 	0 
XtNhlLength	XtCHlLength	Int 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Color 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Color 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNuseXCC	XtCUseXCC	Boolean 	TRUE 
XtNusePrivateColormap	XtCUsePrivateColormap	Boolean 	FALSE 
XtNuseStandardColormaps	XtCUseStandardColormaps	Boolean 	TRUE 
XtNstandardColormap	XtCStandardColormap	Atom 	0 
XtNxcc	XtCXCc	XCC 	create_xcc 
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Color 	XtDefaultForeground 
XtNbackground	XtCBackground	Color 	XtDefaultBackground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

The \fIscroll.h\fP header file is needed for the \fIXfwfScrollInfo\fP
structure.

.nf

.B incl
 <Xfwf/scroll.h>
.fi

The current size and position of the thumb can be queried with the
function \fIgetThumb\fP. It fills the \fIinfo\fP argument with the current values.

.nf
XfwfGetThumb( $, XfwfScrollInfo * info)
.fi

To change the position of the thumb, a call to \fImoveThumb\fP can be
used.  The arguments must be two numbers between 0 and 1.  The thumb
is moved with \fIXCopyArea\fP.

This is a convenience function. The standard interface is through the
\fIscrollResponse\fP resource. In the Slider2 widget, that resource is
connected to the \fIscroll_response\fP method.

.nf
XfwfMoveThumb( $, double  x, double  y)
.fi

Resizing the thumb is done with \fIresizeThumb\fP. The two arguments
must be between 0 and 1.

This is a convenience function. The standard interface is through the
\fIscrollResponse\fP resource. In the Slider2 widget, that resource is
connected to the \fIscroll_response\fP method.

.nf
XfwfResizeThumb( $, double  wd, double  ht)
.fi

.SS "Translations"

The \fIstart\fP action should be bound to a mouse button press, because it
needs the coordinates of the mouse. The \fIdrag\fP action is bound to mouse
movement and the \fIfinish\fP action is normally bound to a release  of the
mouse button.

.nf
<Btn1Down>: start() 
.fi

.nf
<Btn1Motion>: drag() 
.fi

.nf
<Btn1Up>: finish() 
.fi

.SS "Actions"

.TP
.I "start

The \fIstart\fP action checks the position of the mouse and if it was
outside the thumb, it calls the \fIscrollCallback\fP. Otherwise, it only
records the position. Note that the mouse may have been to the left as
well as below the thumb, causing the callbacks to be called twice.

.TP
.I "finish

The \fIfinish\fP action does nothing if this is the end of a
click outside the thumb. The callbacks for this event have already
been called.

If this is the end of a drag action, we reset the flag
\fIdrag_in_progress\fP to False and call the drop callbacks.

.TP
.I "drag

An application that can draw fast enough, may wish to redraw with
every movement of the thumb, instead of only at the end of the drag
action. The drag callback is provided for this purpose. It is called
in the same way as the drop callback, with the current relative
position of the thumb.

