#ifndef _H_JHashCursor
#define _H_JHashCursor

/******************************************************************************
 JHashCursor.h

	Interface for the JHashCursor class.

	Copyright  1997 by Dustin Laurence.  All rights reserved.

	Base code generated by Codemill v0.1.0

 *****************************************************************************/

//Debug only
//#include <iostream.h>

// Superclass header
#include <JConstHashCursor.h>

#include <jTypes.h>

#include <jHashFunctions.h>
#include <JHashRecord.h>

	// forward declaration is necessary to avoid #include loop -- JAFL 5/25/98
	template <class V> class JHashTable;

template <class V>
class JHashCursor : public JConstHashCursor<V>
{
public:

	JHashCursor(JHashTable<V>* table);
	JHashCursor(JHashTable<V>* table, const JHashValue hash);
//	JHashCursor(JHashTable<V>* table, const K* const key);
	virtual ~JHashCursor();

	// Accept built-in forms
	//	JHashCursor(const JHashCursor& source);
	//	const JHashCursor& operator=(const JHashCursor& source);

// Shorthands for common iterator constructs
	void ForceNextOpen();
	void ForceNextMapInsertHash();
	void ForceNextMapInsertKey();

	// Set...
	void Set(const JHashRecord<V>& record) const;
	void Set(const JHashValue hash, const V& value) const;
	void Set(const V& value) const;
	void SetHash(const V& value) const;

	void Remove() const;
	void MarkEmpty() const;

protected:

	JHashTable<V>*  GetMutableTable() const;
};

/******************************************************************************
 GetMutableTable (protected)

 *****************************************************************************/

template <class V>
inline JHashTable<V>*
JHashCursor<V>::GetMutableTable() const
{
	return (JHashTable<V>*) GetTable();
}

/******************************************************************************
 Set

	How a record may be set is restricted just as for individual records to
	make it harder to make errors.  However, for efficiency's sake you don't
	get much hand-holding.  In particularly, those versions which take a key
	but not a value use the hash value the cursor was initialized with; just
	make sure that the key and hash match!

	The record being set must always be in a kFull state after the set.  For
	this reason, Set() automatically sets the state to kFull.

 *****************************************************************************/

template <class V>
inline void
JHashCursor<V>::Set
	(
	const JHashRecord<V>& record
	)
	const
{
	GetMutableTable()->Set(GetIndex(), record);
}


template <class V>
inline void
JHashCursor<V>::Set
	(
	const JHashValue hash,
	const V&         value
	)
	const
{
	GetMutableTable()->Set(GetIndex(), hash, value);
}


template <class V>
inline void
JHashCursor<V>::Set
	(
	const V&    value
	)
	const
{
	GetMutableTable()->Set(GetIndex(), value);
}


template <class V>
inline void
JHashCursor<V>::SetHash
	(
	const V&    value
	)
	const
{
	GetMutableTable()->SetHash(GetIndex(), value);
}

/******************************************************************************
 Remove

 *****************************************************************************/

template <class V>
inline void
JHashCursor<V>::Remove() const
{
	GetMutableTable()->Remove(GetIndex());
}

/******************************************************************************
 MarkEmpty

	DANGER!  Extreme memory leak hazard!

	Don't use this unless you know what you're doing--this is the single easiest
	way to rip a hash table to shreds, and likely leak memory too.

 *****************************************************************************/

template <class V>
inline void
JHashCursor<V>::MarkEmpty() const
{
	GetMutableTable()->MarkEmpty(GetIndex());
}

#endif
