/******************************************************************************
 JPtrArray.h

	Interface for JPtrArray class

	Copyright  1994 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JPtrArray
#define _H_JPtrArray

#include <JArray.h>
#include <JPtrArrayIterator.h>

struct JPtrArrayT
{
	enum CleanUpAction
	{
		kDoNothing,
		kDeleteAllAsObjects,
		kDeleteAllAsArrays
	};
};

template <class T>
class JPtrArray : public JArray<T*>
{
public:

	JPtrArray(const JArrayBlockSize aBlockSize = 10);

	virtual ~JPtrArray();

	void	InsertAtIndex(const JIndex index, T* dataPtr);
	void	Prepend(T* dataPtr);
	void	Append(T* dataPtr);
	void	InsertBefore(const T* beforePtr, T* dataPtr);
	void	InsertAfter(const T* afterPtr, T* dataPtr);
	void	SetToNull(const JIndex index);

	void	Remove(const T* dataPtr);
	void	DeleteElement(const JIndex index);
	void	DeleteAll();
	void	DeleteElementAsArray(const JIndex index);
	void	DeleteAllAsArrays();

	T*		NthElement(const JIndex index);
	T*		FirstElement();
	T*		LastElement();

	const T*	NthElement(const JIndex index) const;
	const T*	FirstElement() const;
	const T*	LastElement() const;

	JBoolean	Includes(const T* dataPtr) const;
	JBoolean	Find(const T* dataPtr, JIndex* elementIndex) const;

	JPtrArrayT::CleanUpAction	GetCleanUpAction() const;
	void						SetCleanUpAction(const JPtrArrayT::CleanUpAction action);

private:

	JPtrArrayT::CleanUpAction	itsCleanUpAction;

private:

	// This is generally fatal for JPtrArrays

	void	QuickSort(int (*compare)(const void*, const void*));
};

#endif
