/******************************************************************************
 JStaticBuffer.h

	Interface for the JStaticBuffer Class

	Copyright  1995 John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JStaticBuffer
#define _H_JStaticBuffer

#include <jTypes.h>

class JStaticBuffer
{
public:

	JStaticBuffer(JCharacter* data = NULL);

	~JStaticBuffer();

	operator JCharacter*() const;

	JCharacter*	GetData() const;
	void		SetData(JCharacter* data);

	JSize	GetLength() const;

private:

	JCharacter*	itsData;

private:

	// not allowed

	JStaticBuffer(const JStaticBuffer& source);
	JStaticBuffer& operator=(const JStaticBuffer& source);
};


/******************************************************************************
 Cast to JCharacter*

 ******************************************************************************/

inline
JStaticBuffer::operator JCharacter*()
	const
{
	return itsData;
}

/******************************************************************************
 GetData

 ******************************************************************************/

inline JCharacter*
JStaticBuffer::GetData()
	const
{
	return itsData;
}

/******************************************************************************
 SetData

 ******************************************************************************/

inline void
JStaticBuffer::SetData
	(
	JCharacter* data
	)
{
	delete [] itsData;
	itsData = data;
}

#endif
