/******************************************************************************
 JValueTableData.h

	Interface for JValueTableData class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JValueTableData
#define _H_JValueTableData

#include <JTableData.h>
#include <JPtrArray.h>

template <class S, class T>
class JValueTableData : public JTableData
{
public:

	JValueTableData(const T& defValue);
	JValueTableData(const JValueTableData<S,T>& source);

	virtual ~JValueTableData();

	const T	GetElement(const JIndex row, const JIndex col) const;
	const T	GetElement(const JPoint& cell) const;
	void	SetElement(const JIndex row, const JIndex col, const T& data);
	void	SetElement(const JPoint& cell, const T& data);

	void	GetRow(const JIndex index, JOrderedSet<T>* rowData) const;
	void	SetRow(const JIndex index, const JOrderedSet<T>& rowData);

	void	GetCol(const JIndex index, JOrderedSet<T>* colData) const;
	void	SetCol(const JIndex index, const JOrderedSet<T>& colData);

	void	InsertRow(const JIndex index, const JOrderedSet<T>* initData = NULL);
	void	PrependRow(const JOrderedSet<T>* initData = NULL);
	void	AppendRow(const JOrderedSet<T>* initData = NULL);
	void	DuplicateRow(const JIndex origIndex, const JIndex newIndex);
	void	RemoveRow(const JIndex index);
	void	RemoveAllRows();
	void	MoveRow(const JIndex origIndex, const JIndex newIndex);

	void	InsertCol(const JIndex index, const JOrderedSet<T>* initData = NULL);
	void	PrependCol(const JOrderedSet<T>* initData = NULL);
	void	AppendCol(const JOrderedSet<T>* initData = NULL);
	void	DuplicateCol(const JIndex origIndex, const JIndex newIndex);
	void	RemoveCol(const JIndex index);
	void	RemoveAllCols();
	void	MoveCol(const JIndex origIndex, const JIndex newIndex);

	const T		GetDefaultValue() const;
	void		SetDefaultValue(const T& data);

private:

	JPtrArray< S >*	itsCols;
	T				itsDefValue;

private:

	// not allowed

	const JValueTableData<S,T>& operator=(const JValueTableData<S,T>& source);
};

#endif
