/******************************************************************************
 jProcessUtil.h

	Interface for jProcessUtil.cc

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_jProcessUtil
#define _H_jProcessUtil

#include <JError.h>
#include <unistd.h>

class JString;

#ifdef __MWERKS__
	typedef unsigned int pid_t;
#else
	#include <sys/types.h>
#endif

// Constants for JExecute()

enum JExecuteAction
{
	kJIgnoreConnection,
	kJCreatePipe,
	kJAttachToFD,
	kJTossOutput,		// output to /dev/null, fromAction and errAction only
	kJAttachToFromFD	// connect stderr to stdout, errAction only
};

// Constants for JWaitForChild()

enum JChildExitReason
{
	kJChildFinished,	// you get return value from main()
	kJChildSignalled,	// you get signal that was sent
	kJChildStopped		// you get signal that was sent
};

// Prototypes

JBoolean	JWillIncludeCWDOnPath();
void		JShouldIncludeCWDOnPath(const JBoolean includeCWD);

JBoolean	JProgramOnPath(const JCharacter* programName);

JError	JExecute(const JCharacter* str, pid_t* childPID,
				 const JExecuteAction toAction = kJIgnoreConnection,
				 int* toFD = NULL,
				 const JExecuteAction fromAction = kJIgnoreConnection,
				 int* fromFD = NULL,
				 const JExecuteAction errAction = kJIgnoreConnection,
				 int* errFD = NULL);

JError	JExecute(const JCharacter* argv[], const JSize count, pid_t* childPID,
				 const JExecuteAction toAction = kJIgnoreConnection,
				 int* toFD = NULL,
				 const JExecuteAction fromAction = kJIgnoreConnection,
				 int* fromFD = NULL,
				 const JExecuteAction errAction = kJIgnoreConnection,
				 int* errFD = NULL);

	// utility functions

JString JPrepArgForExec(const JCharacter* arg);

	// wait for any child -- returns child that finished

JError JWaitForChild(const JBoolean block, pid_t* pid, int* status = NULL);

	// wait for specified child

JError JWaitForChild(const pid_t pid, int* status = NULL);

	// evaluate "status" from JWaitForChild()

JChildExitReason JDecodeChildExitReason(const int status, int* result);

	// send signal

JError JSendSignalToChild(const pid_t pid,  const int signal);
JError JSendSignalToGroup(const pid_t pgid, const int signal);

	// process group

JError	JGetPGID(const pid_t pid, pid_t* pgid);

	// blocking convenience function to run a program

JError	JRunProgram(const JCharacter* cmd, JString* errOutput);

#endif
