#include <JString.h>
#include <JPtrArray.h>
#include <jFStreamUtil.h>
#include <jFileUtil.h>
#include <jDirUtil.h>
#include <jCommandLine.h>
#include <stdio.h>
#include <jAssert.h>

int main()
{
	#ifdef __SC__
		_ftype = 'TEXT';		// request text file -- Think C specific
	#endif

	const JString testFileName = JGetTempFileName();

	remove(testFileName);
	cout << "File exists   (F): " << JFileExists(testFileName) << endl;
	cout << "File writable (F): " << JFileWritable(testFileName) << endl;

	fstream file(testFileName, kJTextFile);
	file.close();
	cout << "File exists   (T): " << JFileExists(testFileName) << endl;
	cout << "File writable (T): " << JFileWritable(testFileName) << endl;

	remove(testFileName);

	JString dirName;
	cout << "Enter a directory name: ";
	cin >> dirName;
	JInputFinished();

	cout << "Directory exists  : " << JDirectoryExists(dirName) << endl;
	cout << "Directory writable: " << JDirectoryWritable(dirName) << endl;

	cout << endl;
	cout << "Creating directory 'junk'" << endl;
	JError err = JCreateDirectory("junk");
	if (!err.OK())
		{
		cout << err.GetMessage() << endl;
		}
	cout << "Renaming directory to 'junk2'" << endl;
	err = JRenameDirectory("junk", "junk2");
	if (!err.OK())
		{
		cout << err.GetMessage() << endl;
		}
	cout << "Deleting directory 'junk2'" << endl;
	err = JRemoveDirectory("junk2");
	if (!err.OK())
		{
		cout << err.GetMessage() << endl;
		cout << "Killing directory 'junk2'" << endl;
		const JBoolean ok = JKillDirectory("junk2");
		cout << "Kill succeeded: " << ok << endl;
		}

	JPtrArray<JString> fileList;
	for (JIndex i=1; i<=200; i++)
		{
		JString* fileName = new JString(JGetTempFileName("/tmp"));
		assert( fileName != NULL );
		fileList.Append(fileName);
		ofstream output(*fileName);	// create it
		}
	cout << endl << "Contents of /tmp:" << endl << endl;
	system("ls /tmp/");
	while (!fileList.IsEmpty())
		{
		remove(*(fileList.FirstElement()));
		fileList.DeleteElement(1);
		}

	return 0;
}
