/******************************************************************************
 JXMenuDirector.cc

	BASE CLASS = JXWindowDirector

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXMenuDirector.h>
#include <JXDisplay.h>
#include <JXWindow.h>
#include <JXMenu.h>
#include <JXMenuTable.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXMenuDirector::JXMenuDirector
	(
	JXDirector*	supervisor,
	JXMenu*		menu
	)
	:
	JXWindowDirector(supervisor)
{
	JXWindow* window =
		new JXWindow(this, 10,10, "", kFalse, menu->GetColormap(), kTrue);
	assert( window != NULL );
	SetWindow(window);

	itsMenuTable = NULL;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXMenuDirector::~JXMenuDirector()
{
}

/******************************************************************************
 BuildWindow

	We have to do this after the constructor is finished because
	CreateMenuTable() is pure virtual.

 ******************************************************************************/

void
JXMenuDirector::BuildWindow
	(
	const JPoint& leftPtR,
	const JPoint& rightPtR
	)
{
	itsMenuTable = CreateMenuTable();
	itsMenuTable->FitToEnclosure();
	itsMenuTable->SetSingleFocusWidget();

	const JCoordinate bw = itsMenuTable->GetBorderWidth();
	const JRect bounds   = itsMenuTable->GetBoundsGlobal();
	const JCoordinate w  = bounds.width()  + 2*bw;
	const JCoordinate h  = bounds.height() + 2*bw;

	const JRect rootBounds = (GetDisplay())->GetBounds();

	JCoordinate windowX, windowWidth = w;
	JPoint usedPtR = rightPtR;
	if (rightPtR.x + w <= rootBounds.right)
		{
		windowX = rightPtR.x;
		}
	else if (leftPtR.x - w >= rootBounds.left)
		{
		windowX = leftPtR.x - w;
		usedPtR = leftPtR;
		}
	else
		{
		windowX = rootBounds.right - w;
		}

	if (windowX + w > rootBounds.right)
		{
		windowX = rootBounds.right - w;
		}
	if (windowX < rootBounds.left)
		{
		windowX = rootBounds.left;
		if (windowX + w > rootBounds.right)
			{
			windowWidth = rootBounds.width();
			}
		}

	JCoordinate windowY, windowHeight = h;
	if (usedPtR.y + h <= rootBounds.bottom)
		{
		windowY = usedPtR.y;
		}
	else
		{
		windowY = rootBounds.bottom - h;
		if (windowY < rootBounds.top)
			{
			windowY      = rootBounds.top;
			windowHeight = rootBounds.height();
			}
		}

	JXWindow* window = GetWindow();
	window->Place(windowX, windowY);
	window->SetSize(windowWidth, windowHeight);
}

/******************************************************************************
 GrabKeyboard

	We can't grab the keyboard until after the window is visible.

 ******************************************************************************/

void
JXMenuDirector::GrabKeyboard()
{
	itsMenuTable->GrabKeyboard();
}

/******************************************************************************
 GrabPointer

	We can't grab the pointer until after the window is visible.
	This should only be called when the menu is activated by a shortcut.

 ******************************************************************************/

void
JXMenuDirector::GrabPointer()
{
	(GetWindow())->GrabPointer(itsMenuTable);
}
