/*
 Copyright (C) 1998 Gerald L. Gay
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(_XDND_H_)
#define _XDND_H_

#include <Xarm/AppContext.h>
#include <Xarm/Label.h>
#include <Xarm/Form.h>
#include <Xarm/DragDrop.h>
#include <Xarm/XarmXpm.h>

class DndDialog
{
 private:

    Pixmap EmptyTrash;
    Pixmap FullTrash;
    Pixmap Bill;
    Pixmap dragIcon;
    Pixmap dragMask;

    Form *theForm;

    Label *Header;
    Label *Trash;
    Label *TheDevil;

    PushButton *emptyButton;

    bool isTrashEmpty;

    Pixmap loadPixmap(Widget, char **pdata);

    bool dragStartProc(Widget, XEvent *, XtPointer);
    void convertProc(Widget, XtPointer, XtPointer);
    void finishProc(Widget, XtPointer, XtPointer);
    void transferProc(Widget, XtPointer, XtPointer);

    void emptyTrash(Widget, XtPointer, XtPointer);

 public:

    DndDialog(Widget parent);
};

class Application: public AppContext
{
 private:
   // internal callback handlers 
   void onExit(Widget,XtPointer,XtPointer);

   // private objects
   DndDialog *p_dnddlg;

 public:
   // application resources
   char *resource_file;
   Boolean show_usage;
   Boolean show_version;

 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);

   static char *basename(char *);
   void get_resources();
   void process_resources();
   void syntax(int opt_no, char **opts);
   void generate_resource_file(char *);
   void usage();
   void version();
}; 

#endif 

