/****************************************************************************
** $Id: qclipbrd.h,v 2.1 1997/08/06 15:05:33 hanord Exp $
**
** Definition of QClipboard class
**
** Created : 960430
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.33.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QCLIPBRD_H
#define QCLIPBRD_H

#include "qobject.h"


class QClipboard : public QObject
{
    Q_OBJECT
private:
    QClipboard( QObject *parent=0, const char *name=0 );
   ~QClipboard();

public:
    void	clear();

    void       *data( const char *format ) const;
    void	setData( const char *format, void * );

    const char *text()	 const;
    void	setText( const char * );
    QPixmap    *pixmap() const;
    void	setPixmap( const QPixmap & );

signals:
    void	dataChanged();

private slots:
    void	ownerDestroyed();

protected:
    void	connectNotify( const char * );
    bool	event( QEvent * );

    friend class QApplication;

private:	// Disabled copy constructor and operator=
    QClipboard( const QClipboard & ) {}
    QClipboard &operator=( const QClipboard & ) { return *this; }
};


#endif // QCLIPBRD_H
