#include <toad/toad.hh>
#include <iostream.h>

class TMyWindow: public TWindow
{
	public:
		TMyWindow(TWindow* p, const string& t):TWindow(p,t){};
	
		void paint();
		void create();
		void adjust();
		void resize();
};

int ToadMain()
{
	return TMyWindow(NULL,"paint-resize").Run();
}

void TMyWindow::create()
{
	cout << "create" << endl;
}

void TMyWindow::paint()
{
	TPen pen(this);

	pen.SetColor(255,192,192);
	for(int x=0; x<Width(); x+=10)
		pen.DrawLine(x,0,x,Height());
	for(int y=0; y<Height(); y+=10)
		pen.DrawLine(0,y,Width(),y);
	
	pen.SetColor(0,0,0);

{	
	TPoint p1(131,11), p2(139,19);
	pen.DrawRectangle(p1.x   , p1.y, 9, 9);
	p1.y+=10; p2.y+=10;
	pen.DrawRectangle(p1.x+9, p1.y+9, -9, -9);
	pen.DrawRectangle(p1.x+9, p1.y+9, 9, 9);
	p1.y+=20; p2.y+=20;
	pen.DrawRectanglePC(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
	p1.y+=10; p2.y+=10;
	pen.DrawRectanglePC(p2.x, p2.y, p1.x-p2.x, p1.y-p2.y);
}	

{	
	TPoint p1(161,11), p2(169,19);
	pen.SetFillColor(128,128,128);
	pen.FillRectangle(p1.x   , p1.y, 9, 9);
	p1.y+=10; p2.y+=10;
	pen.FillRectangle(p1.x+9, p1.y+9, -9, -9);
	pen.FillRectangle(p1.x+9, p1.y+9, 9, 9);
	p1.y+=20; p2.y+=20;
	pen.FillRectanglePC(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
	p1.y+=10; p2.y+=10;
	pen.FillRectanglePC(p2.x, p2.y, p1.x-p2.x, p1.y-p2.y);
	pen.SetColor(0,0,0);
}

{	
	TPoint p1(191,11), p2(199,19);
	pen.FillRectangle(p1.x   , p1.y, 9, 9);
	p1.y+=10; p2.y+=10;
	pen.FillRectangle(p1.x+9, p1.y+9, -9, -9);
	pen.FillRectangle(p1.x+9, p1.y+9, 9, 9);
	p1.y+=20; p2.y+=20;
	pen.FillRectanglePC(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
	p1.y+=10; p2.y+=10;
	pen.FillRectanglePC(p2.x, p2.y, p1.x-p2.x, p1.y-p2.y);
}	

{	
	TPoint p1(211,11), p2(219,19);
	pen.DrawCircle(p1.x   , p1.y, 9, 9);
	p1.y+=10; p2.y+=10;
	pen.DrawCircle(p1.x+9, p1.y+9, -9, -9);
	pen.DrawCircle(p1.x+9, p1.y+9, 9, 9);
	p1.y+=20; p2.y+=20;
	pen.DrawCirclePC(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
	p1.y+=10; p2.y+=10;
	pen.DrawCirclePC(p2.x, p2.y, p1.x-p2.x, p1.y-p2.y);
}	

{	
	TPoint p1(241,11), p2(249,19);
	pen.SetFillColor(128,128,128);
	pen.FillCircle(p1.x   , p1.y, 9, 9);
	p1.y+=10; p2.y+=10;
	pen.FillCircle(p1.x+9, p1.y+9, -9, -9);
	pen.FillCircle(p1.x+9, p1.y+9, 9, 9);
	p1.y+=20; p2.y+=20;
	pen.FillCirclePC(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
	p1.y+=10; p2.y+=10;
	pen.FillCirclePC(p2.x, p2.y, p1.x-p2.x, p1.y-p2.y);
	pen.SetColor(0,0,0);
}

{	
	TPoint p1(271,11), p2(279,19);
	pen.FillCircle(p1.x   , p1.y, 9, 9);
	p1.y+=10; p2.y+=10;
	pen.FillCircle(p1.x+9, p1.y+9, -9, -9);
	pen.FillCircle(p1.x+9, p1.y+9, 9, 9);
	p1.y+=20; p2.y+=20;
	pen.FillCirclePC(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
	p1.y+=10; p2.y+=10;
	pen.FillCirclePC(p2.x, p2.y, p1.x-p2.x, p1.y-p2.y);
}	

#if 0	
	for(int i=0; i<10; i++) {
		pen.DrawRectangle(10*i,10,i,i);
		pen.DrawRectanglePC(10*i,20,i,i);
		pen.DrawRectangle(10*i,40,-i,-i);
		pen.DrawRectanglePC(10*i,50,-i,-i);
#if 0
		pen.FillRectangle(10*i,20,i,i);
		pen.DrawCircle(10*i,30,i,i);
		pen.FillCircle(10*i,40,i,i);
		
		pen.FillRectangle(10*i,60,-i,-i);
		pen.DrawCircle(10*i,70,-i,-i);
		pen.FillCircle(10*i,80,-i,-i);
#endif		
	}
		
	pen.SetColor(0,128,0);
	pen.FillCircle(10,160,5,5);

	pen.SetLineColor(0,0,255);
	pen.FillCircle(20,160,5,5);
	
	pen.SetFillColor(0,0,255);
	pen.FillCircle(30,160,5,5);
	
	pen.SetColor(0,128,0);
	pen.FillCircle(10,170,5,5);
	
	pen.SetFillColor(0,0,255);
	pen.FillCircle(20,170,5,5);

	pen.SetLineColor(0,0,255);
	pen.FillCircle(30,170,5,5);
#endif	
	cout << "paint" << endl;
}

void TMyWindow::adjust()
{
	cout << "adjust" << endl;
}

void TMyWindow::resize()
{
	cout << "resize" << endl;
}
